/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.api.trace;

import javax.annotation.concurrent.Immutable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.ApiUsageLogger;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.OtelEncodingUtils;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.TemporaryBuffers;

@Immutable
public final class SpanId {
    private static final int BYTES_LENGTH = 8;
    private static final int HEX_LENGTH = 16;
    private static final String INVALID = "0000000000000000";

    private SpanId() {
    }

    public static int getLength() {
        return 16;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence spanId) {
        return spanId != null && spanId.length() == 16 && !INVALID.contentEquals(spanId) && OtelEncodingUtils.isValidBase16String(spanId);
    }

    public static String fromBytes(byte[] spanIdBytes) {
        if (spanIdBytes == null || spanIdBytes.length < 8) {
            ApiUsageLogger.log("spanIdBytes is null or too short");
            return INVALID;
        }
        char[] result = TemporaryBuffers.chars(16);
        OtelEncodingUtils.bytesToBase16(spanIdBytes, result, 8);
        return new String(result, 0, 16);
    }

    public static String fromLong(long id) {
        if (id == 0L) {
            return SpanId.getInvalid();
        }
        char[] result = TemporaryBuffers.chars(16);
        OtelEncodingUtils.longToBase16String(id, result, 0);
        return new String(result, 0, 16);
    }
}

