/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class ClassUtilities {
    private static final Set<Class<?>> prims = new HashSet();

    public static int computeInheritanceDistance(Class<?> source2, Class<?> destination) {
        if (source2 == null || destination == null) {
            return -1;
        }
        if (source2.equals(destination)) {
            return 0;
        }
        if (source2.isPrimitive()) {
            if (destination.isPrimitive()) {
                return -1;
            }
            if (!ClassUtilities.isPrimitive(destination)) {
                return -1;
            }
            return ClassUtilities.comparePrimitiveToWrapper(destination, source2);
        }
        if (destination.isPrimitive()) {
            if (!ClassUtilities.isPrimitive(source2)) {
                return -1;
            }
            return ClassUtilities.comparePrimitiveToWrapper(source2, destination);
        }
        LinkedList queue = new LinkedList();
        HashSet visited = new HashSet();
        queue.add(source2);
        visited.add(source2);
        int distance = 0;
        while (!queue.isEmpty()) {
            int levelSize = queue.size();
            ++distance;
            for (int i = 0; i < levelSize; ++i) {
                Class current = (Class)queue.poll();
                if (current.getSuperclass() != null) {
                    if (current.getSuperclass().equals(destination)) {
                        return distance;
                    }
                    if (!visited.contains(current.getSuperclass())) {
                        queue.add(current.getSuperclass());
                        visited.add(current.getSuperclass());
                    }
                }
                for (Class<?> interfaceClass : current.getInterfaces()) {
                    if (interfaceClass.equals(destination)) {
                        return distance;
                    }
                    if (visited.contains(interfaceClass)) continue;
                    queue.add(interfaceClass);
                    visited.add(interfaceClass);
                }
            }
        }
        return -1;
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || prims.contains(c);
    }

    private static int comparePrimitiveToWrapper(Class<?> source2, Class<?> destination) {
        try {
            return source2.getField("TYPE").get(null).equals(destination) ? 0 : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    static {
        prims.add(Byte.class);
        prims.add(Short.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Float.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Boolean.class);
    }
}

