/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.transaction;

import java.sql.SQLException;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionManager;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnector;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnectorFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.xa.XABeginStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.xa.XACommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.xa.XARecoveryStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.xa.XARollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.xa.XAStatement;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.xa.jta.exception.XATransactionNestedBeginException;

public final class TransactionXAHandler
implements ProxyBackendHandler {
    private final XAStatement xaStatement;
    private final ConnectionSession connectionSession;
    private final DatabaseConnector backendHandler;

    public TransactionXAHandler(SQLStatementContext sqlStatementContext, String sql, ConnectionSession connectionSession) {
        this.xaStatement = (XAStatement)sqlStatementContext.getSqlStatement();
        this.connectionSession = connectionSession;
        this.backendHandler = DatabaseConnectorFactory.getInstance().newInstance(new QueryContext(sqlStatementContext, sql, Collections.emptyList(), new HintValueContext(), connectionSession.getConnectionContext(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData()), connectionSession.getDatabaseConnectionManager(), false);
    }

    @Override
    public boolean next() throws SQLException {
        return this.xaStatement instanceof XARecoveryStatement && this.backendHandler.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        return this.xaStatement instanceof XARecoveryStatement ? this.backendHandler.getRowData() : new QueryResponseRow(Collections.emptyList());
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        if (this.xaStatement instanceof XABeginStatement) {
            return this.begin();
        }
        if (this.xaStatement instanceof XACommitStatement || this.xaStatement instanceof XARollbackStatement) {
            return this.finish();
        }
        return this.backendHandler.execute();
    }

    private ResponseHeader begin() throws SQLException {
        ShardingSpherePreconditions.checkState((!this.connectionSession.getTransactionStatus().isInTransaction() ? 1 : 0) != 0, XATransactionNestedBeginException::new);
        ResponseHeader result = this.backendHandler.execute();
        TransactionRule transactionRule = (TransactionRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class);
        ShardingSphereTransactionManagerEngine engine = transactionRule.getResource();
        this.connectionSession.getConnectionContext().getTransactionContext().beginTransaction(transactionRule.getDefaultType().name(), (TransactionManager)engine.getTransactionManager(transactionRule.getDefaultType()));
        return result;
    }

    private ResponseHeader finish() throws SQLException {
        try {
            ResponseHeader responseHeader = this.backendHandler.execute();
            return responseHeader;
        }
        finally {
            this.connectionSession.getConnectionContext().clearTransactionContext();
            this.connectionSession.getConnectionContext().clearCursorContext();
        }
    }

    @Generated
    public TransactionXAHandler(XAStatement xaStatement, ConnectionSession connectionSession, DatabaseConnector backendHandler) {
        this.xaStatement = xaStatement;
        this.connectionSession = connectionSession;
        this.backendHandler = backendHandler;
    }
}

