/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.ral.queryable.export.ExportMetaDataStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.util.ClusterExportMetaDataGenerator;
import org.apache.shardingsphere.proxy.backend.util.ExportUtils;

public final class ExportMetaDataExecutor
implements DistSQLQueryExecutor<ExportMetaDataStatement> {
    public Collection<String> getColumnNames(ExportMetaDataStatement sqlStatement) {
        return Arrays.asList("id", "create_time", "cluster_info");
    }

    public Collection<LocalDataQueryResultRow> getRows(ExportMetaDataStatement sqlStatement, ContextManager contextManager) {
        String exportedData = new ClusterExportMetaDataGenerator(contextManager).generateJsonFormat();
        String instanceId = contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId();
        if (sqlStatement.getFilePath().isPresent()) {
            String filePath = (String)sqlStatement.getFilePath().get();
            ExportUtils.exportToFile(filePath, exportedData);
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{instanceId, LocalDateTime.now(), String.format("Successfully exported to\uff1a'%s'", filePath)}));
        }
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{instanceId, LocalDateTime.now(), Base64.encodeBase64String((byte[])exportedData.getBytes())}));
    }

    public Class<ExportMetaDataStatement> getType() {
        return ExportMetaDataStatement.class;
    }
}

