/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.position.slot;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.position.slot.PostgreSQLReplicationSlotInfo;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.position.slot.PostgreSQLSlotNameGenerator;

public final class PostgreSQLSlotManager {
    private static final String DUPLICATE_OBJECT_ERROR_CODE = "42710";
    private final String decodePlugin;

    public void create(Connection connection, String slotNameSuffix) throws SQLException {
        String slotName = PostgreSQLSlotNameGenerator.getUniqueSlotName(connection, slotNameSuffix);
        Optional<PostgreSQLReplicationSlotInfo> slotInfo = this.load(connection, slotName);
        if (!slotInfo.isPresent()) {
            this.doCreate(connection, slotName);
            return;
        }
        if (null == slotInfo.get().getDatabaseName()) {
            this.doDrop(connection, slotName);
            this.doCreate(connection, slotName);
        }
    }

    private Optional<PostgreSQLReplicationSlotInfo> load(Connection connection, String slotName) throws SQLException {
        String sql = "SELECT slot_name, database FROM pg_replication_slots WHERE slot_name=? AND plugin=?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            Optional<PostgreSQLReplicationSlotInfo> optional;
            block12: {
                preparedStatement.setString(1, slotName);
                preparedStatement.setString(2, this.decodePlugin);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    Optional<PostgreSQLReplicationSlotInfo> optional2 = optional = resultSet.next() ? Optional.of(new PostgreSQLReplicationSlotInfo(resultSet.getString(1), resultSet.getString(2))) : Optional.empty();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return optional;
        }
    }

    private void doCreate(Connection connection, String slotName) throws SQLException {
        block8: {
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM pg_create_logical_replication_slot(?, ?)");){
                preparedStatement.setString(1, slotName);
                preparedStatement.setString(2, this.decodePlugin);
                preparedStatement.execute();
            }
            catch (SQLException ex) {
                if (DUPLICATE_OBJECT_ERROR_CODE.equals(ex.getSQLState())) break block8;
                throw ex;
            }
        }
    }

    public void dropIfExisted(Connection connection, String slotNameSuffix) throws SQLException {
        String slotName = PostgreSQLSlotNameGenerator.getUniqueSlotName(connection, slotNameSuffix);
        if (!this.load(connection, slotName).isPresent()) {
            return;
        }
        this.doDrop(connection, slotName);
    }

    private void doDrop(Connection connection, String slotName) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT pg_drop_replication_slot(?)");){
            preparedStatement.setString(1, slotName);
            preparedStatement.execute();
        }
    }

    @Generated
    public PostgreSQLSlotManager(String decodePlugin) {
        this.decodePlugin = decodePlugin;
    }
}

