/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.fun.SqlArrayValueConstructor;
import org.apache.calcite.sql.fun.SqlMapValueConstructor;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.RelToSqlConverterUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PrestoSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.PRESTO).withIdentifierQuoteString("\"").withUnquotedCasing(Casing.UNCHANGED).withNullCollation(NullCollation.LAST);
    public static final SqlDialect DEFAULT = new PrestoSqlDialect(DEFAULT_CONTEXT);

    public PrestoSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public boolean supportsTimestampPrecision() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        PrestoSqlDialect.unparseUsingLimit(writer, offset, fetch);
    }

    private static void unparseUsingLimit(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        Preconditions.checkArgument((fetch != null || offset != null ? 1 : 0) != 0);
        PrestoSqlDialect.unparseOffset(writer, offset);
        PrestoSqlDialect.unparseLimit(writer, fetch);
    }

    @Override
    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
    }

    @Override
    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case AVG: 
            case COUNT: 
            case CUBE: 
            case SUM: 
            case MIN: 
            case MAX: 
            case ROLLUP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsGroupByWithCube() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public SqlDialect.CalendarPolicy getCalendarPolicy() {
        return SqlDialect.CalendarPolicy.SHIFT;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        return super.getCastSpec(type);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            RelToSqlConverterUtil.specialOperatorByName("SUBSTR").unparse(writer, call, 0, 0);
        } else if (call.getOperator() == SqlStdOperatorTable.APPROX_COUNT_DISTINCT) {
            RelToSqlConverterUtil.specialOperatorByName("APPROX_DISTINCT").unparse(writer, call, 0, 0);
        } else {
            switch (call.getKind()) {
                case MAP_VALUE_CONSTRUCTOR: {
                    PrestoSqlDialect.unparseMapValue(writer, call, leftPrec, rightPrec);
                    break;
                }
                default: {
                    PostgresqlSqlDialect.DEFAULT.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }

    @Override
    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        MysqlSqlDialect.DEFAULT.unparseSqlIntervalQualifier(writer, qualifier, typeSystem);
    }

    private static void unparseMapValue(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        call = PrestoSqlDialect.convertMapValueCall(call);
        writer.keyword(call.getOperator().getName());
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    private static SqlCall convertMapValueCall(SqlCall call) {
        boolean unnestMap;
        boolean bl = unnestMap = call.operandCount() > 0 && call.getOperandList().stream().allMatch(operand -> operand instanceof SqlLiteral);
        if (!unnestMap) {
            return call;
        }
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        for (int i = 0; i < call.operandCount(); ++i) {
            if (i % 2 == 0) {
                keys.add(call.operand(i));
                continue;
            }
            values.add(call.operand(i));
        }
        SqlParserPos pos = call.getParserPosition();
        return new SqlBasicCall((SqlOperator)new SqlMapValueConstructor(), (List<? extends SqlNode>)ImmutableList.of((Object)new SqlBasicCall((SqlOperator)new SqlArrayValueConstructor(), keys, pos), (Object)new SqlBasicCall((SqlOperator)new SqlArrayValueConstructor(), values, pos)), pos);
    }
}

