/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.distsql.statement.ShowMaskRulesStatement;
import org.apache.shardingsphere.mask.rule.MaskRule;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowMaskRuleExecutor
implements DistSQLQueryExecutor<ShowMaskRulesStatement>,
DistSQLExecutorRuleAware<MaskRule> {
    private MaskRule rule;

    public Collection<String> getColumnNames(ShowMaskRulesStatement sqlStatement) {
        return Arrays.asList("table", "column", "algorithm_type", "algorithm_props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowMaskRulesStatement sqlStatement, ContextManager contextManager) {
        return this.rule.getConfiguration().getTables().stream().filter(each -> null == sqlStatement.getTableName() || each.getName().equalsIgnoreCase(sqlStatement.getTableName())).map(each -> this.buildColumnData((MaskTableRuleConfiguration)each, this.rule.getConfiguration().getMaskAlgorithms())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<LocalDataQueryResultRow> buildColumnData(MaskTableRuleConfiguration tableRuleConfig, Map<String, AlgorithmConfiguration> maskAlgorithmConfigs) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        tableRuleConfig.getColumns().forEach(each -> {
            AlgorithmConfiguration maskAlgorithmConfig = (AlgorithmConfiguration)maskAlgorithmConfigs.get(each.getMaskAlgorithm());
            result.add(new LocalDataQueryResultRow(new Object[]{tableRuleConfig.getName(), each.getLogicColumn(), maskAlgorithmConfig.getType(), maskAlgorithmConfig.getProps()}));
        });
        return result;
    }

    public Class<MaskRule> getRuleClass() {
        return MaskRule.class;
    }

    public Class<ShowMaskRulesStatement> getType() {
        return ShowMaskRulesStatement.class;
    }

    @Generated
    public void setRule(MaskRule rule) {
        this.rule = rule;
    }
}

