/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.context;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.context.ExecutionType;

public final class TaskContext {
    private static final String DELIMITER = "@-@";
    private static final String UNASSIGNED_SLAVE_ID = "unassigned-slave";
    private String id;
    private final MetaInfo metaInfo;
    private final ExecutionType type;
    private String slaveId;
    private boolean idle;

    public TaskContext(String jobName, List<Integer> shardingItem, ExecutionType type) {
        this(jobName, shardingItem, type, UNASSIGNED_SLAVE_ID);
    }

    public TaskContext(String jobName, List<Integer> shardingItem, ExecutionType type, String slaveId) {
        this.metaInfo = new MetaInfo(jobName, shardingItem);
        this.type = type;
        this.slaveId = slaveId;
        this.id = String.join((CharSequence)DELIMITER, this.metaInfo.toString(), type.toString(), slaveId, UUID.randomUUID().toString());
    }

    private TaskContext(String id, MetaInfo metaInfo, ExecutionType type, String slaveId) {
        this.id = id;
        this.metaInfo = metaInfo;
        this.type = type;
        this.slaveId = slaveId;
    }

    public static TaskContext from(String id) {
        String[] result = id.split(DELIMITER);
        Preconditions.checkState((5 == result.length ? 1 : 0) != 0);
        return new TaskContext(id, MetaInfo.from(result[0] + DELIMITER + result[1]), ExecutionType.valueOf(result[2]), result[3]);
    }

    public static String getIdForUnassignedSlave(String id) {
        return id.replaceAll(TaskContext.from(id).getSlaveId(), UNASSIGNED_SLAVE_ID);
    }

    public void setSlaveId(String slaveId) {
        this.id = this.id.replaceAll(this.slaveId, slaveId);
        this.slaveId = slaveId;
    }

    public String getTaskName() {
        return String.join((CharSequence)DELIMITER, this.metaInfo.toString(), this.type.toString(), this.slaveId);
    }

    public String getExecutorId(String appName) {
        return String.join((CharSequence)DELIMITER, appName, this.slaveId);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    @Generated
    public ExecutionType getType() {
        return this.type;
    }

    @Generated
    public String getSlaveId() {
        return this.slaveId;
    }

    @Generated
    public boolean isIdle() {
        return this.idle;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskContext)) {
            return false;
        }
        TaskContext other = (TaskContext)o;
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskContext(id=" + this.getId() + ")";
    }

    @Generated
    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    public static class MetaInfo {
        private final String jobName;
        private final List<Integer> shardingItems;

        public static MetaInfo from(String value) {
            String[] result = value.split(TaskContext.DELIMITER);
            Preconditions.checkState((1 == result.length || 2 == result.length || 5 == result.length ? 1 : 0) != 0);
            return new MetaInfo(result[0], 1 == result.length || "".equals(result[1]) ? Collections.emptyList() : Splitter.on((String)",").splitToList((CharSequence)result[1]).stream().map(Integer::parseInt).collect(Collectors.toList()));
        }

        public final String toString() {
            return String.join((CharSequence)TaskContext.DELIMITER, this.jobName, this.shardingItems.stream().map(Object::toString).collect(Collectors.joining(",")));
        }

        @Generated
        public MetaInfo(String jobName, List<Integer> shardingItems) {
            this.jobName = jobName;
            this.shardingItems = shardingItems;
        }

        @Generated
        public String getJobName() {
            return this.jobName;
        }

        @Generated
        public List<Integer> getShardingItems() {
            return this.shardingItems;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaInfo)) {
                return false;
            }
            MetaInfo other = (MetaInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jobName = this.getJobName();
            String other$jobName = other.getJobName();
            if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
                return false;
            }
            List<Integer> this$shardingItems = this.getShardingItems();
            List<Integer> other$shardingItems = other.getShardingItems();
            return !(this$shardingItems == null ? other$shardingItems != null : !((Object)this$shardingItems).equals(other$shardingItems));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MetaInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jobName = this.getJobName();
            result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
            List<Integer> $shardingItems = this.getShardingItems();
            result = result * 59 + ($shardingItems == null ? 43 : ((Object)$shardingItems).hashCode());
            return result;
        }
    }
}

