/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.type;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleOperator;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.statement.rdl.rule.database.DatabaseRuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.decorator.RuleConfigurationDecorator;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;

public final class AlterDatabaseRuleOperator
implements DatabaseRuleOperator {
    private final ContextManager contextManager;
    private final DatabaseRuleAlterExecutor executor;

    @Override
    public void operate(DatabaseRuleDefinitionStatement sqlStatement, ShardingSphereDatabase database, RuleConfiguration currentRuleConfig) throws SQLException {
        Object toBeAlteredRuleConfig = this.executor.buildToBeAlteredRuleConfiguration(sqlStatement);
        MetaDataManagerPersistService metaDataManagerPersistService = this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService();
        metaDataManagerPersistService.alterRuleConfiguration(database.getName(), this.decorateRuleConfiguration(database, (RuleConfiguration)toBeAlteredRuleConfig));
        Object toBeDroppedRuleConfig = this.executor.buildToBeDroppedRuleConfiguration(toBeAlteredRuleConfig);
        metaDataManagerPersistService.removeRuleConfigurationItem(database.getName(), toBeDroppedRuleConfig);
    }

    private RuleConfiguration decorateRuleConfiguration(ShardingSphereDatabase database, RuleConfiguration ruleConfig) {
        return TypedSPILoader.findService(RuleConfigurationDecorator.class, ruleConfig.getClass()).map(optional -> optional.decorate(database.getName(), (Map)database.getResourceMetaData().getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)), database.getRuleMetaData().getRules(), ruleConfig)).orElse(ruleConfig);
    }

    @Generated
    public AlterDatabaseRuleOperator(ContextManager contextManager, DatabaseRuleAlterExecutor executor) {
        this.contextManager = contextManager;
        this.executor = executor;
    }
}

