/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.service;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineJobCreationWithInvalidShardingCountException;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.PipelineJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.pojo.PipelineJobInfo;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.PipelineGovernanceFacade;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineDistributedBarrier;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobManager.class);
    private final PipelineJobType jobType;

    public void start(PipelineJobConfiguration jobConfig) {
        String jobId = jobConfig.getJobId();
        ShardingSpherePreconditions.checkState((0 != jobConfig.getJobShardingCount() ? 1 : 0) != 0, () -> new PipelineJobCreationWithInvalidShardingCountException(jobId));
        PipelineGovernanceFacade governanceFacade = PipelineAPIFactory.getPipelineGovernanceFacade(PipelineJobIdUtils.parseContextKey(jobId));
        if (governanceFacade.getJobFacade().getConfiguration().isExisted(jobId)) {
            log.warn("jobId already exists in registry center, ignore, job id is `{}`", (Object)jobId);
            return;
        }
        governanceFacade.getJobFacade().getJob().create(jobId, this.jobType.getJobClass());
        governanceFacade.getJobFacade().getConfiguration().persist(jobId, new PipelineJobConfigurationManager(this.jobType).convertToJobConfigurationPOJO(jobConfig));
    }

    public void resume(String jobId) {
        Optional jobItemProgress;
        if (this.jobType.isIgnoreToStartDisabledJobWhenJobItemProgressIsFinished() && (jobItemProgress = new PipelineJobItemManager(this.jobType.getYamlJobItemProgressSwapper()).getProgress(jobId, 0)).isPresent() && JobStatus.FINISHED == ((PipelineJobItemProgress)jobItemProgress.get()).getStatus()) {
            log.info("job status is FINISHED, ignore, jobId={}", (Object)jobId);
            return;
        }
        this.startCurrentDisabledJob(jobId);
        this.jobType.getToBeStartDisabledNextJobType().ifPresent(optional -> this.startNextDisabledJob(jobId, (String)optional));
    }

    private void startCurrentDisabledJob(String jobId) {
        PipelineDistributedBarrier pipelineDistributedBarrier = PipelineDistributedBarrier.getInstance(PipelineJobIdUtils.parseContextKey(jobId));
        pipelineDistributedBarrier.unregister(PipelineMetaDataNode.getJobBarrierDisablePath(jobId));
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO(jobId);
        jobConfigPOJO.setDisabled(false);
        jobConfigPOJO.getProps().setProperty("start_time_millis", String.valueOf(System.currentTimeMillis()));
        jobConfigPOJO.getProps().remove("stop_time");
        jobConfigPOJO.getProps().setProperty("run_count", String.valueOf(Integer.parseInt(jobConfigPOJO.getProps().getProperty("run_count", "0")) + 1));
        String barrierEnablePath = PipelineMetaDataNode.getJobBarrierEnablePath(jobId);
        pipelineDistributedBarrier.register(barrierEnablePath, jobConfigPOJO.getShardingTotalCount());
        PipelineAPIFactory.getJobConfigurationAPI(PipelineJobIdUtils.parseContextKey(jobId)).updateJobConfiguration(jobConfigPOJO);
        pipelineDistributedBarrier.await(barrierEnablePath, 5L, TimeUnit.SECONDS);
    }

    private void startNextDisabledJob(String jobId, String toBeStartDisabledNextJobType) {
        PipelineAPIFactory.getPipelineGovernanceFacade(PipelineJobIdUtils.parseContextKey(jobId)).getJobFacade().getCheck().findLatestCheckJobId(jobId).ifPresent(optional -> {
            try {
                new PipelineJobManager((PipelineJobType)TypedSPILoader.getService(PipelineJobType.class, (Object)toBeStartDisabledNextJobType)).resume((String)optional);
            }
            catch (RuntimeException ex) {
                log.warn("start related check job failed, check job id: {}, error: {}", optional, (Object)ex.getMessage());
            }
        });
    }

    public void stop(String jobId) {
        this.jobType.getToBeStoppedPreviousJobType().ifPresent(optional -> this.stopPreviousJob(jobId, (String)optional));
        this.stopCurrentJob(jobId);
    }

    private void stopPreviousJob(String jobId, String toBeStoppedPreviousJobType) {
        PipelineAPIFactory.getPipelineGovernanceFacade(PipelineJobIdUtils.parseContextKey(jobId)).getJobFacade().getCheck().findLatestCheckJobId(jobId).ifPresent(optional -> {
            try {
                new PipelineJobManager((PipelineJobType)TypedSPILoader.getService(PipelineJobType.class, (Object)toBeStoppedPreviousJobType)).stop((String)optional);
            }
            catch (RuntimeException ex) {
                log.warn("stop related check job failed, check job id: {}, error: {}", optional, (Object)ex.getMessage());
            }
        });
    }

    private void stopCurrentJob(String jobId) {
        PipelineDistributedBarrier pipelineDistributedBarrier = PipelineDistributedBarrier.getInstance(PipelineJobIdUtils.parseContextKey(jobId));
        pipelineDistributedBarrier.unregister(PipelineMetaDataNode.getJobBarrierEnablePath(jobId));
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO(jobId);
        jobConfigPOJO.setDisabled(true);
        jobConfigPOJO.getProps().setProperty("stop_time", LocalDateTime.now().format(DateTimeFormatterFactory.getStandardFormatter()));
        String barrierPath = PipelineMetaDataNode.getJobBarrierDisablePath(jobId);
        pipelineDistributedBarrier.register(barrierPath, jobConfigPOJO.getShardingTotalCount());
        PipelineAPIFactory.getJobConfigurationAPI(PipelineJobIdUtils.parseContextKey(jobId)).updateJobConfiguration(jobConfigPOJO);
        pipelineDistributedBarrier.await(barrierPath, 5L, TimeUnit.SECONDS);
    }

    public void drop(String jobId) {
        PipelineContextKey contextKey = PipelineJobIdUtils.parseContextKey(jobId);
        PipelineAPIFactory.getJobOperateAPI(contextKey).remove(String.valueOf(jobId), null);
        PipelineAPIFactory.getPipelineGovernanceFacade(contextKey).getJobFacade().getJob().delete(jobId);
    }

    public List<PipelineJobInfo> getJobInfos(PipelineContextKey contextKey) {
        try {
            return PipelineAPIFactory.getJobStatisticsAPI(contextKey).getAllJobsBriefInfo().stream().filter(each -> !each.getJobName().startsWith("_") && this.jobType.getType().equals(PipelineJobIdUtils.parseJobType(each.getJobName()).getType())).map(each -> this.jobType.getJobInfo(each.getJobName())).collect(Collectors.toList());
        }
        catch (UnsupportedOperationException ex) {
            return Collections.emptyList();
        }
    }

    @Generated
    public PipelineJobManager(PipelineJobType jobType) {
        this.jobType = jobType;
    }
}

