/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.importer.sink.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineImporterJobWriteException;
import org.apache.shardingsphere.data.pipeline.core.importer.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.PipelineSink;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.RecordUtils;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.group.DataRecordGroupEngine;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.group.GroupedDataRecord;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelineImportSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDataSourceSink
implements PipelineSink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDataSourceSink.class);
    private final ImporterConfiguration importerConfig;
    private final DataSource dataSource;
    private final PipelineImportSQLBuilder importSQLBuilder;
    private final DataRecordGroupEngine groupEngine;
    private final AtomicReference<PreparedStatement> runningStatement;

    public PipelineDataSourceSink(ImporterConfiguration importerConfig, PipelineDataSourceManager dataSourceManager) {
        this.importerConfig = importerConfig;
        this.dataSource = dataSourceManager.getDataSource(importerConfig.getDataSourceConfig());
        this.importSQLBuilder = new PipelineImportSQLBuilder(importerConfig.getDataSourceConfig().getDatabaseType());
        this.groupEngine = new DataRecordGroupEngine();
        this.runningStatement = new AtomicReference();
    }

    @Override
    public PipelineJobUpdateProgress write(String ackId, Collection<Record> records) {
        List<DataRecord> dataRecords = records.stream().filter(DataRecord.class::isInstance).map(DataRecord.class::cast).collect(Collectors.toList());
        if (dataRecords.isEmpty()) {
            return new PipelineJobUpdateProgress(0);
        }
        for (GroupedDataRecord each2 : this.groupEngine.group(dataRecords)) {
            this.batchWrite(each2.getDeleteDataRecords());
            this.batchWrite(each2.getInsertDataRecords());
            this.batchWrite(each2.getUpdateDataRecords());
        }
        return new PipelineJobUpdateProgress((int)dataRecords.stream().filter(each -> PipelineSQLOperationType.INSERT == each.getType()).count());
    }

    private void batchWrite(Collection<DataRecord> records) {
        if (records.isEmpty()) {
            return;
        }
        for (int i = 0; !Thread.interrupted() && i <= this.importerConfig.getRetryTimes(); ++i) {
            try {
                this.doWrite(records, 0 == i);
                break;
            }
            catch (SQLException ex) {
                log.error("Flush failed {}/{} times.", new Object[]{i, this.importerConfig.getRetryTimes(), ex});
                if (i == this.importerConfig.getRetryTimes()) {
                    throw new PipelineImporterJobWriteException(ex);
                }
                Thread.sleep(Math.min(300000L, 1000L << i));
                continue;
            }
        }
    }

    private void doWrite(Collection<DataRecord> records, boolean firstTimeRun) throws SQLException {
        switch (records.iterator().next().getType()) {
            case INSERT: {
                Optional.ofNullable(this.importerConfig.getRateLimitAlgorithm()).ifPresent(optional -> optional.intercept(PipelineSQLOperationType.INSERT, 1));
                this.executeBatchInsert(records, firstTimeRun);
                break;
            }
            case UPDATE: {
                Optional.ofNullable(this.importerConfig.getRateLimitAlgorithm()).ifPresent(optional -> optional.intercept(PipelineSQLOperationType.UPDATE, 1));
                this.executeUpdate(records, firstTimeRun);
                break;
            }
            case DELETE: {
                Optional.ofNullable(this.importerConfig.getRateLimitAlgorithm()).ifPresent(optional -> optional.intercept(PipelineSQLOperationType.DELETE, 1));
                this.executeBatchDelete(records);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchInsert(Collection<DataRecord> dataRecords, boolean firstTimeRun) throws SQLException {
        DataRecord dataRecord = dataRecords.iterator().next();
        String sql = this.importSQLBuilder.buildInsertSQL(this.importerConfig.findSchemaName(dataRecord.getTableName()).orElse(null), dataRecord);
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            this.runningStatement.set(preparedStatement);
            if (firstTimeRun) {
                this.executeBatchInsertFirstTime(connection, preparedStatement, dataRecords);
            } else {
                this.retryBatchInsert(preparedStatement, dataRecords);
            }
        }
        finally {
            this.runningStatement.set(null);
        }
    }

    private void executeBatchInsertFirstTime(Connection connection, PreparedStatement preparedStatement, Collection<DataRecord> dataRecords) throws SQLException {
        boolean transactionEnabled;
        boolean bl = transactionEnabled = dataRecords.size() > 1;
        if (transactionEnabled) {
            connection.setAutoCommit(false);
        }
        preparedStatement.setQueryTimeout(30);
        for (DataRecord each : dataRecords) {
            for (int i = 0; i < each.getColumnCount(); ++i) {
                preparedStatement.setObject(i + 1, each.getColumn(i).getValue());
            }
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        if (transactionEnabled) {
            connection.commit();
        }
    }

    private void retryBatchInsert(PreparedStatement preparedStatement, Collection<DataRecord> dataRecords) throws SQLException {
        for (DataRecord each : dataRecords) {
            for (int i = 0; i < each.getColumnCount(); ++i) {
                preparedStatement.setObject(i + 1, each.getColumn(i).getValue());
            }
            preparedStatement.executeUpdate();
        }
    }

    private void executeUpdate(Collection<DataRecord> dataRecords, boolean firstTimeRun) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            boolean transactionEnabled;
            boolean bl = transactionEnabled = dataRecords.size() > 1 && firstTimeRun;
            if (transactionEnabled) {
                connection.setAutoCommit(false);
            }
            for (DataRecord each : dataRecords) {
                this.executeUpdate(connection, each);
            }
            if (transactionEnabled) {
                connection.commit();
            }
        }
    }

    private void executeUpdate(Connection connection, DataRecord dataRecord) throws SQLException {
        Set<String> shardingColumns = this.importerConfig.getShardingColumns(dataRecord.getTableName());
        List<Column> conditionColumns = RecordUtils.extractConditionColumns(dataRecord, shardingColumns);
        List setColumns = dataRecord.getColumns().stream().filter(Column::isUpdated).collect(Collectors.toList());
        String sql = this.importSQLBuilder.buildUpdateSQL(this.importerConfig.findSchemaName(dataRecord.getTableName()).orElse(null), dataRecord, conditionColumns);
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int i;
            this.runningStatement.set(preparedStatement);
            for (i = 0; i < setColumns.size(); ++i) {
                preparedStatement.setObject(i + 1, ((Column)setColumns.get(i)).getValue());
            }
            for (i = 0; i < conditionColumns.size(); ++i) {
                Column keyColumn = conditionColumns.get(i);
                if (shardingColumns.contains(keyColumn.getName()) && null == keyColumn.getOldValue()) {
                    preparedStatement.setObject(setColumns.size() + i + 1, keyColumn.getValue());
                    continue;
                }
                preparedStatement.setObject(setColumns.size() + i + 1, keyColumn.getOldValue());
            }
            int updateCount = preparedStatement.executeUpdate();
            if (1 != updateCount) {
                log.warn("Update failed, update count: {}, sql: {}, set columns: {}, sharding columns: {}, condition columns: {}", new Object[]{updateCount, sql, setColumns, JsonUtils.toJsonString(shardingColumns), JsonUtils.toJsonString(conditionColumns)});
            }
        }
        catch (SQLException ex) {
            log.error("execute update failed, sql: {}, set columns: {}, sharding columns: {}, condition columns: {}, error message: {}, data record: {}", new Object[]{sql, setColumns, JsonUtils.toJsonString(shardingColumns), JsonUtils.toJsonString(conditionColumns), ex.getMessage(), dataRecord});
            throw ex;
        }
        finally {
            this.runningStatement.set(null);
        }
    }

    private void executeBatchDelete(Collection<DataRecord> dataRecords) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            boolean transactionEnabled;
            boolean bl = transactionEnabled = dataRecords.size() > 1;
            if (transactionEnabled) {
                connection.setAutoCommit(false);
            }
            this.executeBatchDelete(connection, dataRecords, this.importerConfig.getShardingColumns(dataRecords.iterator().next().getTableName()));
            if (transactionEnabled) {
                connection.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchDelete(Connection connection, Collection<DataRecord> dataRecords, Set<String> shardingColumns) throws SQLException {
        DataRecord dataRecord = dataRecords.iterator().next();
        String deleteSQL = this.importSQLBuilder.buildDeleteSQL(this.importerConfig.findSchemaName(dataRecord.getTableName()).orElse(null), dataRecord, RecordUtils.extractConditionColumns(dataRecord, shardingColumns));
        try (PreparedStatement preparedStatement = connection.prepareStatement(deleteSQL);){
            this.runningStatement.set(preparedStatement);
            preparedStatement.setQueryTimeout(30);
            for (DataRecord each : dataRecords) {
                List<Column> conditionColumns = RecordUtils.extractConditionColumns(each, this.importerConfig.getShardingColumns(each.getTableName()));
                for (int i = 0; i < conditionColumns.size(); ++i) {
                    Object oldValue = conditionColumns.get(i).getOldValue();
                    if (null == oldValue) {
                        log.warn("Record old value is null, record: {}", (Object)each);
                    }
                    preparedStatement.setObject(i + 1, oldValue);
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        finally {
            this.runningStatement.set(null);
        }
    }

    @Override
    public void close() {
        Optional.ofNullable(this.runningStatement.get()).ifPresent(PipelineJdbcUtils::cancelStatement);
    }
}

