/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLockRegistry;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.metadata.ComputeNodePath;

public final class ShowProcessListHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return ComputeNodePath.getShowProcessListTriggerRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        Matcher matcher = this.getShowProcessListTriggerMatcher(event);
        if (matcher.find()) {
            this.handle(contextManager, event, matcher);
        }
    }

    private void handle(ContextManager contextManager, DataChangedEvent event, Matcher matcher) {
        String instanceId = matcher.group(1);
        String taskId = matcher.group(2);
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            if (instanceId.equals(contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId())) {
                contextManager.getPersistCoordinatorFacade().getProcessPersistCoordinator().reportLocalProcesses(instanceId, taskId);
            }
        } else if (DataChangedEvent.Type.DELETED == event.getType()) {
            ProcessOperationLockRegistry.getInstance().notify(taskId);
        }
    }

    private Matcher getShowProcessListTriggerMatcher(DataChangedEvent event) {
        return Pattern.compile(ComputeNodePath.getShowProcessListTriggerRootPath() + "/([\\S]+):([\\S]+)$", 2).matcher(event.getKey());
    }
}

