/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.state.datasource.qualified.QualifiedDataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.yaml.YamlQualifiedDataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.yaml.YamlQualifiedDataSourceStateSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.metadata.QualifiedDataSourceNodePath;

public final class QualifiedDataSourceChangedHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return QualifiedDataSourceNodePath.getRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        if (Strings.isNullOrEmpty((String)event.getValue())) {
            return;
        }
        Optional qualifiedDataSource = QualifiedDataSourceNodePath.findQualifiedDataSource((String)event.getKey());
        if (!qualifiedDataSource.isPresent()) {
            return;
        }
        QualifiedDataSourceState state = new YamlQualifiedDataSourceStateSwapper().swapToObject((YamlQualifiedDataSourceState)YamlEngine.unmarshal((String)event.getValue(), YamlQualifiedDataSourceState.class));
        this.handleQualifiedDataSourceStateChanged(contextManager.getMetaDataContexts().getMetaData(), (QualifiedDataSource)qualifiedDataSource.get(), state);
    }

    private void handleQualifiedDataSourceStateChanged(ShardingSphereMetaData metaData, QualifiedDataSource qualifiedDataSource, QualifiedDataSourceState state) {
        Preconditions.checkState((boolean)metaData.containsDatabase(qualifiedDataSource.getDatabaseName()), (String)"No database '%s' exists.", (Object)qualifiedDataSource.getDatabaseName());
        metaData.getDatabase(qualifiedDataSource.getDatabaseName()).getRuleMetaData().getAttributes(StaticDataSourceRuleAttribute.class).forEach(each -> each.updateStatus(qualifiedDataSource, state.getState()));
    }
}

