/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.listener.type.DatabaseMetaDataChangedListener;
import org.apache.shardingsphere.mode.metadata.refresher.ShardingSphereStatisticsRefreshEngine;
import org.apache.shardingsphere.mode.node.path.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.metadata.StatesNodePath;
import org.apache.shardingsphere.mode.persist.service.unified.ListenerAssistedType;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;

public final class ListenerAssistedChangedHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return StatesNodePath.getListenerAssistedNodeRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        StatesNodePath.findDatabaseName((String)event.getKey()).ifPresent(optional -> ListenerAssistedChangedHandler.handle(contextManager, optional, ListenerAssistedType.valueOf((String)event.getValue())));
    }

    private static void handle(ContextManager contextManager, String databaseName, ListenerAssistedType listenerAssistedType) {
        ClusterPersistRepository repository = (ClusterPersistRepository)contextManager.getPersistServiceFacade().getRepository();
        if (ListenerAssistedType.CREATE_DATABASE == listenerAssistedType) {
            repository.watch(DatabaseMetaDataNodePath.getDatabasePath((String)databaseName), (DataChangedEventListener)new DatabaseMetaDataChangedListener(contextManager));
            contextManager.getMetaDataContextManager().getSchemaMetaDataManager().addDatabase(databaseName);
        } else if (ListenerAssistedType.DROP_DATABASE == listenerAssistedType) {
            repository.removeDataListener(DatabaseMetaDataNodePath.getDatabasePath((String)databaseName));
            contextManager.getMetaDataContextManager().getSchemaMetaDataManager().dropDatabase(databaseName);
        }
        contextManager.getPersistServiceFacade().getListenerAssistedPersistService().deleteDatabaseNameListenerAssisted(databaseName);
        if (InstanceType.PROXY == contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getType()) {
            new ShardingSphereStatisticsRefreshEngine(contextManager).asyncRefresh();
        }
    }
}

