/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.yaml.swapper.rule;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;

public final class YamlShardingTableReferenceRuleConfigurationConverter {
    private static final int GENERATE_NAME_LENGTH = 16;

    public static String convertToYamlString(ShardingTableReferenceRuleConfiguration data) {
        return String.format("%s:%s", data.getName(), data.getReference());
    }

    public static ShardingTableReferenceRuleConfiguration convertToObject(String referenceConfig) {
        return referenceConfig.contains(":") ? YamlShardingTableReferenceRuleConfigurationConverter.convertYamlConfigurationWithName(referenceConfig) : YamlShardingTableReferenceRuleConfigurationConverter.convertYamlConfigurationWithoutName(referenceConfig);
    }

    private static ShardingTableReferenceRuleConfiguration convertYamlConfigurationWithName(String referenceConfig) {
        String name = referenceConfig.substring(0, referenceConfig.indexOf(58));
        String reference = referenceConfig.substring(referenceConfig.indexOf(58) + 1);
        return new ShardingTableReferenceRuleConfiguration(name, reference);
    }

    private static ShardingTableReferenceRuleConfiguration convertYamlConfigurationWithoutName(String referenceConfig) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        String name = new UUID(threadLocalRandom.nextLong(), threadLocalRandom.nextLong()).toString().replace("-", "").substring(0, 16);
        return new ShardingTableReferenceRuleConfiguration(name, referenceConfig);
    }

    @Generated
    private YamlShardingTableReferenceRuleConfigurationConverter() {
    }
}

