/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.checker.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class ShardingRouteContextCheckUtils {
    public static boolean isSameRouteContext(RouteContext routeContext, RouteContext subRouteContext) {
        if (routeContext.getRouteUnits().size() != subRouteContext.getRouteUnits().size()) {
            return false;
        }
        Iterator routeContextIterator = routeContext.getRouteUnits().iterator();
        Iterator setAssignmentRouteContextIterator = subRouteContext.getRouteUnits().iterator();
        while (routeContextIterator.hasNext()) {
            RouteUnit routeUnit = (RouteUnit)routeContextIterator.next();
            RouteUnit setAssignmentRouteUnit = (RouteUnit)setAssignmentRouteContextIterator.next();
            if (!routeUnit.getDataSourceMapper().getLogicName().equals(setAssignmentRouteUnit.getDataSourceMapper().getLogicName()) || !routeUnit.getDataSourceMapper().getActualName().equals(setAssignmentRouteUnit.getDataSourceMapper().getActualName())) {
                return false;
            }
            if (ShardingRouteContextCheckUtils.isSameTableMapper(routeUnit.getTableMappers(), setAssignmentRouteUnit.getTableMappers())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameTableMapper(Collection<RouteMapper> tableMappers, Collection<RouteMapper> setAssignmentTableMappers) {
        if (tableMappers.size() != setAssignmentTableMappers.size()) {
            return false;
        }
        Iterator<RouteMapper> tableMapperIterator = tableMappers.iterator();
        Iterator<RouteMapper> setAssignmentTableMapperIterator = setAssignmentTableMappers.iterator();
        while (tableMapperIterator.hasNext()) {
            RouteMapper routeMapper = tableMapperIterator.next();
            RouteMapper setAssignmentRouteMapper = setAssignmentTableMapperIterator.next();
            if (routeMapper.getLogicName().equals(setAssignmentRouteMapper.getLogicName()) && routeMapper.getActualName().equals(setAssignmentRouteMapper.getActualName())) continue;
            return false;
        }
        return true;
    }

    public static Optional<ShardingConditions> createShardingConditions(SQLStatementContext sqlStatementContext, ShardingRule shardingRule, Collection<ColumnAssignmentSegment> assignments, List<Object> params) {
        LinkedList values = new LinkedList();
        String tableName = (String)((TableAvailable)sqlStatementContext).getTablesContext().getTableNames().iterator().next();
        for (ColumnAssignmentSegment each : assignments) {
            String shardingColumn = ((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue();
            if (!shardingRule.findShardingColumn(shardingColumn, tableName).isPresent()) continue;
            Optional<Object> assignmentValue = ShardingRouteContextCheckUtils.getShardingColumnAssignmentValue(each, params);
            assignmentValue.ifPresent(optional -> values.add(new ListShardingConditionValue<Object>(shardingColumn, tableName, Collections.singletonList(optional))));
        }
        if (values.isEmpty()) {
            return Optional.empty();
        }
        ShardingCondition shardingCondition = new ShardingCondition();
        shardingCondition.getValues().addAll(values);
        return Optional.of(new ShardingConditions(Collections.singletonList(shardingCondition), sqlStatementContext, shardingRule));
    }

    private static Optional<Object> getShardingColumnAssignmentValue(ColumnAssignmentSegment assignmentSegment, List<Object> params) {
        ExpressionSegment segment = assignmentSegment.getValue();
        int shardingSetAssignIndex = -1;
        if (segment instanceof ParameterMarkerExpressionSegment) {
            shardingSetAssignIndex = ((ParameterMarkerExpressionSegment)segment).getParameterMarkerIndex();
        }
        if (segment instanceof LiteralExpressionSegment) {
            return Optional.of(((LiteralExpressionSegment)segment).getLiterals());
        }
        if (-1 == shardingSetAssignIndex || shardingSetAssignIndex > params.size() - 1) {
            return Optional.empty();
        }
        return Optional.of(params.get(shardingSetAssignIndex));
    }

    @Generated
    private ShardingRouteContextCheckUtils() {
    }
}

