/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.checker;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sharding.route.engine.checker.ShardingRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.ddl.ShardingAlterTableRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.ddl.ShardingCreateTableRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.ddl.ShardingCreateViewRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.ddl.ShardingDropIndexRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.ddl.ShardingDropTableRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.ddl.ShardingPrepareRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.ddl.ShardingRenameTableRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.dml.ShardingDeleteRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.dml.ShardingInsertRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.dml.ShardingUpdateRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.PrepareStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class ShardingRouteContextCheckerFactory {
    public static Optional<ShardingRouteContextChecker> newInstance(SQLStatement sqlStatement, ShardingConditions shardingConditions) {
        if (sqlStatement instanceof DDLStatement) {
            return ShardingRouteContextCheckerFactory.getDDLRouteContextChecker(sqlStatement);
        }
        if (sqlStatement instanceof DMLStatement) {
            return ShardingRouteContextCheckerFactory.getDMLRouteContextChecker(sqlStatement, shardingConditions);
        }
        return Optional.empty();
    }

    private static Optional<ShardingRouteContextChecker> getDDLRouteContextChecker(SQLStatement sqlStatement) {
        if (sqlStatement instanceof CreateTableStatement) {
            return Optional.of(new ShardingCreateTableRouteContextChecker());
        }
        if (sqlStatement instanceof CreateViewStatement) {
            return Optional.of(new ShardingCreateViewRouteContextChecker());
        }
        if (sqlStatement instanceof AlterTableStatement) {
            return Optional.of(new ShardingAlterTableRouteContextChecker());
        }
        if (sqlStatement instanceof RenameTableStatement) {
            return Optional.of(new ShardingRenameTableRouteContextChecker());
        }
        if (sqlStatement instanceof DropTableStatement) {
            return Optional.of(new ShardingDropTableRouteContextChecker());
        }
        if (sqlStatement instanceof DropIndexStatement) {
            return Optional.of(new ShardingDropIndexRouteContextChecker());
        }
        if (sqlStatement instanceof PrepareStatement) {
            return Optional.of(new ShardingPrepareRouteContextChecker());
        }
        return Optional.empty();
    }

    private static Optional<ShardingRouteContextChecker> getDMLRouteContextChecker(SQLStatement sqlStatement, ShardingConditions shardingConditions) {
        if (sqlStatement instanceof InsertStatement) {
            return Optional.of(new ShardingInsertRouteContextChecker(shardingConditions));
        }
        if (sqlStatement instanceof UpdateStatement) {
            return Optional.of(new ShardingUpdateRouteContextChecker());
        }
        if (sqlStatement instanceof DeleteStatement) {
            return Optional.of(new ShardingDeleteRouteContextChecker());
        }
        return Optional.empty();
    }

    @Generated
    private ShardingRouteContextCheckerFactory() {
    }
}

