/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingTokenUtils;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ShardingTableToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue tableName;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule shardingRule;

    public ShardingTableToken(int startIndex, int stopIndex, IdentifierValue tableSegment, SQLStatementContext sqlStatementContext, ShardingRule shardingRule) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.tableName = tableSegment;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRule = shardingRule;
    }

    public String toString(RouteUnit routeUnit) {
        return this.getActualTableName(routeUnit);
    }

    private String getActualTableName(RouteUnit routeUnit) {
        String actualTableName = ShardingTokenUtils.getLogicAndActualTableMap(routeUnit, this.sqlStatementContext, this.shardingRule).get(this.tableName.getValue());
        actualTableName = null == actualTableName ? this.tableName.getValue() : actualTableName;
        return this.tableName.getQuoteCharacter().wrap(actualTableName);
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

