/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.builder.SQLTokenGeneratorBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator.GeneratedKeyAssignmentTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator.GeneratedKeyForUseDefaultInsertColumnsTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator.GeneratedKeyInsertColumnTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator.GeneratedKeyInsertValuesTokenGenerator;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingAggregationDistinctTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingConstraintTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingCursorTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingDistinctProjectionPrefixTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingFetchDirectionTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingIndexTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingInsertValuesTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingOffsetTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingOrderByTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingProjectionsTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingRemoveTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingRowCountTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.ShardingTableTokenGenerator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingTokenGenerateBuilder
implements SQLTokenGeneratorBuilder {
    private final ShardingRule rule;
    private final RouteContext routeContext;
    private final SQLStatementContext sqlStatementContext;

    public Collection<SQLTokenGenerator> getSQLTokenGenerators() {
        LinkedList<SQLTokenGenerator> result = new LinkedList<SQLTokenGenerator>();
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingTableTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingDistinctProjectionPrefixTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingProjectionsTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingOrderByTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingAggregationDistinctTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingIndexTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingConstraintTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingOffsetTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingRowCountTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new GeneratedKeyInsertColumnTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new GeneratedKeyForUseDefaultInsertColumnsTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new GeneratedKeyAssignmentTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingInsertValuesTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new GeneratedKeyInsertValuesTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingRemoveTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingCursorTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new ShardingFetchDirectionTokenGenerator());
        return result;
    }

    private void addSQLTokenGenerator(Collection<SQLTokenGenerator> sqlTokenGenerators, SQLTokenGenerator toBeAddedSQLTokenGenerator) {
        if (toBeAddedSQLTokenGenerator instanceof IgnoreForSingleRoute && this.routeContext.isSingleRouting()) {
            return;
        }
        if (toBeAddedSQLTokenGenerator instanceof RouteContextAware) {
            ((RouteContextAware)toBeAddedSQLTokenGenerator).setRouteContext(this.routeContext);
        }
        if (toBeAddedSQLTokenGenerator.isGenerateSQLToken(this.sqlStatementContext)) {
            sqlTokenGenerators.add(toBeAddedSQLTokenGenerator);
        }
    }

    @Generated
    public ShardingTokenGenerateBuilder(ShardingRule rule, RouteContext routeContext, SQLStatementContext sqlStatementContext) {
        this.rule = rule;
        this.routeContext = routeContext;
        this.sqlStatementContext = sqlStatementContext;
    }
}

