/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache.route.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Optional;
import org.apache.shardingsphere.sharding.api.config.cache.ShardingCacheOptionsConfiguration;
import org.apache.shardingsphere.sharding.cache.route.cache.ShardingRouteCacheKey;
import org.apache.shardingsphere.sharding.cache.route.cache.ShardingRouteCacheValue;

public final class ShardingRouteCache {
    private final Cache<ShardingRouteCacheKey, ShardingRouteCacheValue> cache;

    public ShardingRouteCache(ShardingCacheOptionsConfiguration cacheOptions) {
        this.cache = this.buildRouteCache(cacheOptions);
    }

    private Cache<ShardingRouteCacheKey, ShardingRouteCacheValue> buildRouteCache(ShardingCacheOptionsConfiguration cacheOptions) {
        Caffeine result = Caffeine.newBuilder().initialCapacity(cacheOptions.getInitialCapacity()).maximumSize((long)cacheOptions.getMaximumSize());
        if (cacheOptions.isSoftValues()) {
            result.softValues();
        }
        return result.build();
    }

    public void put(ShardingRouteCacheKey key, ShardingRouteCacheValue value) {
        this.cache.put((Object)key, (Object)value);
    }

    public Optional<ShardingRouteCacheValue> get(ShardingRouteCacheKey key) {
        return Optional.ofNullable((ShardingRouteCacheValue)this.cache.getIfPresent((Object)key));
    }
}

