/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.url.core.arg;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.url.core.arg.URLArgumentPlaceholderType;

public final class URLArgumentLine {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\$\\{(.*?)::(.*?)}");
    private final Matcher placeholderMatcher;

    public static Optional<URLArgumentLine> parse(String line) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(line);
        if (!matcher.find()) {
            return Optional.empty();
        }
        return Optional.of(new URLArgumentLine(matcher));
    }

    public String replaceArgument(URLArgumentPlaceholderType type) {
        this.placeholderMatcher.reset();
        StringBuffer result = new StringBuffer();
        while (this.placeholderMatcher.find()) {
            String variableName = this.placeholderMatcher.group(1);
            String defaultValue = this.placeholderMatcher.group(2);
            String argumentValue = this.getArgumentValue(variableName, type);
            if (Strings.isNullOrEmpty((String)argumentValue)) {
                argumentValue = defaultValue;
            }
            this.placeholderMatcher.appendReplacement(result, argumentValue);
        }
        this.placeholderMatcher.appendTail(result);
        return this.rightTrim(result);
    }

    private String rightTrim(StringBuffer buffer) {
        while (buffer.length() > 0 && Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private String getArgumentValue(String argName, URLArgumentPlaceholderType type) {
        if (URLArgumentPlaceholderType.ENVIRONMENT == type) {
            return System.getenv(argName);
        }
        if (URLArgumentPlaceholderType.SYSTEM_PROPS == type) {
            return System.getProperty(argName);
        }
        return null;
    }

    @Generated
    private URLArgumentLine(Matcher placeholderMatcher) {
        this.placeholderMatcher = placeholderMatcher;
    }
}

