/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.transaction;

import java.sql.SQLException;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.savepoint.ShardingSphereSavepoint;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.TCLStatement;
import org.apache.shardingsphere.transaction.core.TransactionOperationType;

public final class DriverTransactionSQLStatementExecutor {
    private final ShardingSphereConnection connection;
    private TransactionOperationType operationType;

    public DriverTransactionSQLStatementExecutor(ShardingSphereConnection connection) {
        this.connection = connection;
    }

    public boolean decide(QueryContext queryContext) {
        if (!(queryContext.getSqlStatementContext().getSqlStatement() instanceof TCLStatement)) {
            return false;
        }
        TCLStatement tclStatement = (TCLStatement)queryContext.getSqlStatementContext().getSqlStatement();
        if (tclStatement instanceof SavepointStatement) {
            this.operationType = TransactionOperationType.SAVEPOINT;
            return true;
        }
        if (tclStatement instanceof ReleaseSavepointStatement) {
            this.operationType = TransactionOperationType.RELEASE_SAVEPOINT;
            return true;
        }
        return false;
    }

    public boolean execute(TCLStatement tclStatement) throws SQLException {
        if (TransactionOperationType.SAVEPOINT == this.operationType) {
            this.connection.setSavepoint(((SavepointStatement)tclStatement).getSavepointName());
            return true;
        }
        if (TransactionOperationType.RELEASE_SAVEPOINT == this.operationType) {
            ShardingSphereSavepoint savepoint = new ShardingSphereSavepoint(((ReleaseSavepointStatement)tclStatement).getSavepointName());
            this.connection.releaseSavepoint(savepoint);
            return true;
        }
        return false;
    }
}

