/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DatabaseTypeEngine {
    private static final String DEFAULT_DATABASE_TYPE = "MySQL";

    public static DatabaseType getProtocolType(DatabaseConfiguration databaseConfig, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeEngine.findConfiguredDatabaseType(props);
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Collection<DataSource> dataSources = DatabaseTypeEngine.getDataSources(databaseConfig).values();
        return dataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType(dataSources.iterator().next());
    }

    public static DatabaseType getProtocolType(Map<String, ? extends DatabaseConfiguration> databaseConfigs, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeEngine.findConfiguredDatabaseType(props);
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Map<String, DataSource> dataSources = DatabaseTypeEngine.getDataSources(databaseConfigs);
        return dataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType(dataSources.values().iterator().next());
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType(ConfigurationProperties props) {
        DatabaseType configuredDatabaseType = (DatabaseType)props.getValue(ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return null == configuredDatabaseType ? Optional.empty() : Optional.of(configuredDatabaseType.getTrunkDatabaseType().orElse(configuredDatabaseType));
    }

    private static Map<String, DataSource> getDataSources(Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, ? extends DatabaseConfiguration> entry : databaseConfigs.entrySet()) {
            result.putAll(DatabaseTypeEngine.getDataSources(entry.getValue()));
        }
        return result;
    }

    private static Map<String, DataSource> getDataSources(DatabaseConfiguration databaseConfig) {
        return databaseConfig.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DatabaseType getStorageType(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = DatabaseTypeFactory.get((String)connection.getMetaData().getURL());
            return databaseType;
        }
        catch (SQLFeatureNotSupportedException sqlFeatureNotSupportedException) {
            try (Connection connection2 = dataSource.getConnection();){
                Class<?> hiveConnectionClass = Class.forName("org.apache.hive.jdbc.HiveConnection");
                if (!connection2.isWrapperFor(hiveConnectionClass)) throw new SQLWrapperException((SQLException)sqlFeatureNotSupportedException);
                Object hiveConnection = connection2.unwrap(hiveConnectionClass);
                String connectedUrl = (String)hiveConnectionClass.getMethod("getConnectedUrl", new Class[0]).invoke(hiveConnection, new Object[0]);
                DatabaseType databaseType2 = DatabaseTypeFactory.get((String)connectedUrl);
                return databaseType2;
            }
            catch (SQLException ex) {
                throw new SQLWrapperException(ex);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new SQLWrapperException(new SQLException(ex));
            }
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    public static DatabaseType getDefaultStorageType() {
        return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)DEFAULT_DATABASE_TYPE);
    }

    @Generated
    private DatabaseTypeEngine() {
    }
}

