/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqltranslator.rule;

import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sqltranslator.config.SQLTranslatorRuleConfiguration;
import org.apache.shardingsphere.sqltranslator.context.SQLTranslatorContext;
import org.apache.shardingsphere.sqltranslator.exception.SQLTranslationException;
import org.apache.shardingsphere.sqltranslator.spi.SQLTranslator;

public final class SQLTranslatorRule
implements GlobalRule {
    private final SQLTranslatorRuleConfiguration configuration;
    private final SQLTranslator translator;
    private final boolean useOriginalSQLWhenTranslatingFailed;

    public SQLTranslatorRule(SQLTranslatorRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        this.translator = (SQLTranslator)TypedSPILoader.getService(SQLTranslator.class, (Object)ruleConfig.getType(), (Properties)ruleConfig.getProps());
        this.useOriginalSQLWhenTranslatingFailed = ruleConfig.isUseOriginalSQLWhenTranslatingFailed();
    }

    public SQLTranslatorContext translate(String sql, List<Object> parameters, QueryContext queryContext, DatabaseType storageType, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData) {
        DatabaseType sqlParserType = queryContext.getSqlStatementContext().getDatabaseType();
        if (sqlParserType.equals(storageType) || null == storageType) {
            return new SQLTranslatorContext(sql, parameters);
        }
        try {
            return this.translator.translate(sql, parameters, queryContext, storageType, database, globalRuleMetaData);
        }
        catch (SQLTranslationException ex) {
            if (this.useOriginalSQLWhenTranslatingFailed) {
                return new SQLTranslatorContext(sql, parameters);
            }
            throw ex;
        }
    }

    public int getOrder() {
        return 900;
    }

    @Generated
    public SQLTranslatorRuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

