/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;

public final class QualifiedDataSourceNodePath {
    private static final String ROOT_NODE = "/nodes";
    private static final String QUALIFIED_DATA_SOURCES_NODE = "qualified_data_sources";
    private static final String QUALIFIED_DATA_SOURCE_PATTERN = "(\\S+)";

    public static String getRootPath() {
        return String.join((CharSequence)"/", ROOT_NODE, QUALIFIED_DATA_SOURCES_NODE);
    }

    public static String getQualifiedDataSourcePath(QualifiedDataSource qualifiedDataSource) {
        return String.join((CharSequence)"/", QualifiedDataSourceNodePath.getRootPath(), qualifiedDataSource.toString());
    }

    public static Optional<QualifiedDataSource> findQualifiedDataSource(String qualifiedDataSourcePath) {
        Pattern pattern = Pattern.compile(String.join((CharSequence)"/", QualifiedDataSourceNodePath.getRootPath(), "(\\S+)$"), 2);
        Matcher matcher = pattern.matcher(qualifiedDataSourcePath);
        return matcher.find() ? Optional.of(new QualifiedDataSource(matcher.group(1))) : Optional.empty();
    }

    @Generated
    private QualifiedDataSourceNodePath() {
    }
}

