/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.savepoint;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import java.util.UUID;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class ShardingSphereSavepoint
implements Savepoint {
    private final String savepointName;

    public ShardingSphereSavepoint() {
        this.savepointName = UUID.randomUUID().toString().replaceAll("-", "_");
    }

    public ShardingSphereSavepoint(String savepointName) throws SQLException {
        ShardingSpherePreconditions.checkNotEmpty((String)savepointName, () -> new SQLFeatureNotSupportedException("Savepoint name can not be NULL or empty"));
        this.savepointName = savepointName;
    }

    @Override
    public int getSavepointId() throws SQLException {
        throw new SQLFeatureNotSupportedException("Only named savepoint are supported.");
    }

    @Override
    @Generated
    public String getSavepointName() {
        return this.savepointName;
    }
}

