/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.algorithm.replace;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.security.SecureRandom;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class GenericTableRandomReplaceAlgorithm
implements MaskAlgorithm<Object, String> {
    private static final String UPPERCASE_LETTER_CODES = "uppercase-letter-codes";
    private static final String LOWERCASE_LETTER_CODES = "lowercase-letter-codes";
    private static final String DIGITAL_CODES = "digital-codes";
    private static final String SPECIAL_CODES = "special-codes";
    private static final String DEFAULT_UPPERCASE_LETTER_CODES = "A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z";
    private static final String DEFAULT_LOWERCASE_LETTER_CODES = "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z";
    private static final String DEFAULT_DIGITAL_CODES = "0,1,2,3,4,5,6,7,8,9";
    private static final String DEFAULT_SPECIAL_CODES = "~,!,@,#,$,%,^,&,*,:,<,>,|";
    private final Random random = new SecureRandom();
    private List<Character> uppercaseLetterCodes;
    private List<Character> lowercaseLetterCodes;
    private List<Character> digitalCodes;
    private List<Character> specialCodes;

    public void init(Properties props) {
        this.uppercaseLetterCodes = this.splitPropsToList(props.getProperty(UPPERCASE_LETTER_CODES, DEFAULT_UPPERCASE_LETTER_CODES));
        this.lowercaseLetterCodes = this.splitPropsToList(props.getProperty(LOWERCASE_LETTER_CODES, DEFAULT_LOWERCASE_LETTER_CODES));
        this.digitalCodes = this.splitPropsToList(props.getProperty(DIGITAL_CODES, DEFAULT_DIGITAL_CODES));
        ShardingSpherePreconditions.checkNotEmpty(this.digitalCodes, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "'%s' must be not empty", new Object[]{DIGITAL_CODES}));
        this.specialCodes = this.splitPropsToList(props.getProperty(SPECIAL_CODES, DEFAULT_SPECIAL_CODES));
        ShardingSpherePreconditions.checkNotEmpty(this.specialCodes, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "'%s' must be not empty", new Object[]{SPECIAL_CODES}));
    }

    private List<Character> splitPropsToList(String props) {
        return Splitter.on((String)",").trimResults().splitToList((CharSequence)props).stream().map(each -> Character.valueOf(each.charAt(0))).collect(Collectors.toList());
    }

    public String mask(Object plainValue) {
        String result;
        String string = result = null == plainValue ? null : String.valueOf(plainValue);
        if (Strings.isNullOrEmpty((String)result)) {
            return result;
        }
        char[] chars = result.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            chars[i] = 'A' <= c && c <= 'Z' ? this.uppercaseLetterCodes.get(this.random.nextInt(this.uppercaseLetterCodes.size())).charValue() : ('a' <= c && c <= 'z' ? this.lowercaseLetterCodes.get(this.random.nextInt(this.lowercaseLetterCodes.size())).charValue() : ('0' <= c && c <= '9' ? this.digitalCodes.get(this.random.nextInt(this.digitalCodes.size())).charValue() : this.specialCodes.get(this.random.nextInt(this.specialCodes.size())).charValue()));
        }
        return new String(chars);
    }

    public String getType() {
        return "GENERIC_TABLE_RANDOM_REPLACE";
    }
}

