/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;

public final class PhysicalResourceAggregator {
    public static Map<String, DataSource> getAggregatedResources(Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        Object result = new CaseInsensitiveMap(dataSourceMap);
        for (ShardingSphereRule each : builtRules) {
            Optional<DataSourceMapperRuleAttribute> ruleAttribute = each.getAttributes().findAttribute(DataSourceMapperRuleAttribute.class);
            if (!ruleAttribute.isPresent()) continue;
            result = PhysicalResourceAggregator.getAggregatedResources((Map<String, DataSource>)result, ruleAttribute.get());
        }
        return result;
    }

    private static Map<String, DataSource> getAggregatedResources(Map<String, DataSource> dataSourceMap, DataSourceMapperRuleAttribute ruleAttribute) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (Map.Entry<String, Collection<String>> entry : ruleAttribute.getDataSourceMapper().entrySet()) {
            for (String each : entry.getValue()) {
                if (!dataSourceMap.containsKey(each)) continue;
                result.putIfAbsent(entry.getKey(), dataSourceMap.remove(each));
            }
        }
        result.putAll(dataSourceMap);
        return result;
    }

    @Generated
    private PhysicalResourceAggregator() {
    }
}

