/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;

@ThreadSafe
public final class ComputeNodeInstanceContext {
    private final ComputeNodeInstance instance;
    private final AtomicReference<WorkerIdGenerator> workerIdGenerator = new AtomicReference();
    private final ModeConfiguration modeConfiguration;
    private final AtomicReference<LockContext> lockContext = new AtomicReference();
    private final EventBusContext eventBusContext;
    private final Collection<ComputeNodeInstance> allClusterInstances = new CopyOnWriteArrayList<ComputeNodeInstance>();

    public ComputeNodeInstanceContext(ComputeNodeInstance instance, WorkerIdGenerator workerIdGenerator, ModeConfiguration modeConfig, LockContext lockContext, EventBusContext eventBusContext) {
        this.instance = instance;
        this.workerIdGenerator.set(workerIdGenerator);
        this.modeConfiguration = modeConfig;
        this.lockContext.set(lockContext);
        this.eventBusContext = eventBusContext;
    }

    public ComputeNodeInstanceContext(ComputeNodeInstance instance, ModeConfiguration modeConfig, EventBusContext eventBusContext) {
        this(instance, null, modeConfig, null, eventBusContext);
    }

    public void init(WorkerIdGenerator workerIdGenerator, LockContext lockContext) {
        this.workerIdGenerator.set(workerIdGenerator);
        this.lockContext.set(lockContext);
    }

    public void updateStatus(String id, String status) {
        Optional<InstanceState> instanceState = InstanceState.get(status);
        if (!instanceState.isPresent()) {
            return;
        }
        if (this.instance.getMetaData().getId().equals(id)) {
            this.instance.switchState(instanceState.get());
        }
        this.updateRelatedComputeNodeInstancesStatus(id, instanceState.get());
    }

    private void updateRelatedComputeNodeInstancesStatus(String instanceId, InstanceState instanceState) {
        for (ComputeNodeInstance each : this.allClusterInstances) {
            if (!each.getMetaData().getId().equals(instanceId)) continue;
            each.switchState(instanceState);
        }
    }

    public void updateWorkerId(String instanceId, Integer workerId) {
        if (this.instance.getMetaData().getId().equals(instanceId)) {
            this.instance.setWorkerId(workerId);
        }
        this.allClusterInstances.stream().filter(each -> each.getMetaData().getId().equals(instanceId)).forEach(each -> each.setWorkerId(workerId));
    }

    public void updateLabel(String instanceId, Collection<String> labels) {
        if (this.instance.getMetaData().getId().equals(instanceId)) {
            this.instance.getLabels().clear();
            this.instance.getLabels().addAll(labels);
        }
        for (ComputeNodeInstance each : this.allClusterInstances) {
            if (!each.getMetaData().getId().equals(instanceId)) continue;
            each.getLabels().clear();
            each.getLabels().addAll(labels);
        }
    }

    public int getWorkerId() {
        return this.instance.getWorkerId();
    }

    public int generateWorkerId(Properties props) {
        Preconditions.checkArgument((this.workerIdGenerator.get() != null ? 1 : 0) != 0, (Object)"Worker id generator is not initialized.");
        int result = this.workerIdGenerator.get().generate(props);
        this.instance.setWorkerId(result);
        return result;
    }

    public void addComputeNodeInstance(ComputeNodeInstance instance) {
        this.allClusterInstances.removeIf(each -> each.getMetaData().getId().equalsIgnoreCase(instance.getMetaData().getId()));
        this.allClusterInstances.add(instance);
    }

    public void deleteComputeNodeInstance(ComputeNodeInstance instance) {
        this.allClusterInstances.removeIf(each -> each.getMetaData().getId().equalsIgnoreCase(instance.getMetaData().getId()));
    }

    public Map<String, InstanceMetaData> getAllClusterInstances(InstanceType instanceType, Collection<String> labels) {
        LinkedHashMap<String, InstanceMetaData> result = new LinkedHashMap<String, InstanceMetaData>(this.allClusterInstances.size(), 1.0f);
        for (ComputeNodeInstance each : this.allClusterInstances) {
            if (each.getMetaData().getType() != instanceType) continue;
            if (!labels.stream().anyMatch(each.getLabels()::contains)) continue;
            result.put(each.getMetaData().getId(), each.getMetaData());
        }
        return result;
    }

    public Optional<ComputeNodeInstance> getComputeNodeInstanceById(String instanceId) {
        return this.allClusterInstances.stream().filter(each -> instanceId.equals(each.getMetaData().getId())).findFirst();
    }

    public LockContext getLockContext() throws IllegalStateException {
        return Optional.ofNullable(this.lockContext.get()).orElseThrow(() -> new IllegalStateException("Lock context is not initialized."));
    }

    @Generated
    public ComputeNodeInstance getInstance() {
        return this.instance;
    }

    @Generated
    public ModeConfiguration getModeConfiguration() {
        return this.modeConfiguration;
    }

    @Generated
    public EventBusContext getEventBusContext() {
        return this.eventBusContext;
    }

    @Generated
    public Collection<ComputeNodeInstance> getAllClusterInstances() {
        return this.allClusterInstances;
    }
}

