/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.kernel.data.UnsupportedDataTypeConversionException;
import org.apache.shardingsphere.infra.exception.kernel.data.UnsupportedStreamCharsetConversionException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.metadata.JDBCQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.stream.AbstractStreamQueryResult;

public final class JDBCStreamQueryResult
extends AbstractStreamQueryResult {
    private final ResultSet resultSet;

    public JDBCStreamQueryResult(ResultSet resultSet) throws SQLException {
        super(new JDBCQueryResultMetaData(resultSet.getMetaData()));
        this.resultSet = resultSet;
    }

    @Override
    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Boolean.TYPE == type) {
            return this.resultSet.getBoolean(columnIndex);
        }
        if (Byte.TYPE == type) {
            return this.resultSet.getByte(columnIndex);
        }
        if (Short.TYPE == type) {
            return this.resultSet.getShort(columnIndex);
        }
        if (Integer.TYPE == type) {
            return this.resultSet.getInt(columnIndex);
        }
        if (Long.TYPE == type) {
            return this.resultSet.getLong(columnIndex);
        }
        if (Float.TYPE == type) {
            return Float.valueOf(this.resultSet.getFloat(columnIndex));
        }
        if (Double.TYPE == type) {
            return this.resultSet.getDouble(columnIndex);
        }
        if (String.class == type) {
            return this.resultSet.getString(columnIndex);
        }
        if (BigDecimal.class == type) {
            return this.resultSet.getBigDecimal(columnIndex);
        }
        if (byte[].class == type) {
            return this.resultSet.getBytes(columnIndex);
        }
        if (Date.class == type) {
            return this.resultSet.getDate(columnIndex);
        }
        if (Time.class == type) {
            return this.resultSet.getTime(columnIndex);
        }
        if (Timestamp.class == type) {
            return this.resultSet.getTimestamp(columnIndex);
        }
        if (Blob.class == type) {
            return this.resultSet.getBlob(columnIndex);
        }
        if (Clob.class == type) {
            return this.resultSet.getClob(columnIndex);
        }
        if (Array.class == type) {
            return this.resultSet.getArray(columnIndex);
        }
        return this.resultSet.getObject(columnIndex);
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        if (Date.class == type) {
            return this.resultSet.getDate(columnIndex, calendar);
        }
        if (Time.class == type) {
            return this.resultSet.getTime(columnIndex, calendar);
        }
        if (Timestamp.class == type) {
            return this.resultSet.getTimestamp(columnIndex, calendar);
        }
        throw new UnsupportedDataTypeConversionException(type, (Object)calendar).toSQLException();
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        switch (type) {
            case "Ascii": {
                return this.resultSet.getAsciiStream(columnIndex);
            }
            case "Unicode": {
                return this.resultSet.getUnicodeStream(columnIndex);
            }
            case "Binary": {
                return this.resultSet.getBinaryStream(columnIndex);
            }
        }
        throw new UnsupportedStreamCharsetConversionException(type).toSQLException();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.resultSet.getCharacterStream(columnIndex);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    @Override
    public void close() throws SQLException {
        this.resultSet.close();
    }

    @Generated
    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

