/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateIndexStatement;

public final class CreateIndexStatementSchemaRefresher
implements MetaDataRefresher<CreateIndexStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, CreateIndexStatement sqlStatement, ConfigurationProperties props) {
        String indexName = null == sqlStatement.getIndex() ? IndexMetaDataUtils.getGeneratedLogicIndexName((Collection)sqlStatement.getColumns()) : sqlStatement.getIndex().getIndexName().getIdentifier().getValue();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)indexName) ? 1 : 0) != 0, (Object)"Index name is not exist.");
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        ShardingSphereTable table = this.newShardingSphereTable(database.getSchema(schemaName).getTable(tableName));
        table.putIndex(new ShardingSphereIndex(indexName));
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName);
        alterSchemaMetaDataPOJO.getAlteredTables().add(table);
        metaDataManagerPersistService.alterSchemaMetaData(alterSchemaMetaDataPOJO);
    }

    private ShardingSphereTable newShardingSphereTable(ShardingSphereTable table) {
        ShardingSphereTable result = new ShardingSphereTable(table.getName(), table.getColumnValues(), table.getIndexValues(), table.getConstraintValues(), table.getType());
        result.getColumnNames().addAll(table.getColumnNames());
        result.getVisibleColumns().addAll(table.getVisibleColumns());
        result.getPrimaryKeyColumns().addAll(table.getPrimaryKeyColumns());
        return result;
    }

    @Override
    public Class<CreateIndexStatement> getType() {
        return CreateIndexStatement.class;
    }
}

