/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.apache.shardingsphere.mode.tuple.annotation.RepositoryTupleEntity;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalConfigurationManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigurationManager.class);
    private final AtomicReference<MetaDataContexts> metaDataContexts;
    private final MetaDataPersistService metaDataPersistService;

    public GlobalConfigurationManager(AtomicReference<MetaDataContexts> metaDataContexts, PersistRepository repository) {
        this.metaDataContexts = metaDataContexts;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    public synchronized void alterGlobalRuleConfiguration(RuleConfiguration ruleConfig) {
        if (null == ruleConfig) {
            return;
        }
        this.closeStaleTransactionRule(ruleConfig);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(this.metaDataContexts.get().getMetaData().getGlobalRuleMetaData().getRules());
        rules.removeIf(each -> each.getConfiguration().getClass().isAssignableFrom(ruleConfig.getClass()));
        rules.addAll(GlobalRulesBuilder.buildSingleRules((RuleConfiguration)ruleConfig, (Map)this.metaDataContexts.get().getMetaData().getDatabases(), (ConfigurationProperties)this.metaDataContexts.get().getMetaData().getProps()));
        this.metaDataContexts.get().getMetaData().getGlobalRuleMetaData().getRules().clear();
        this.metaDataContexts.get().getMetaData().getGlobalRuleMetaData().getRules().addAll(rules);
        ShardingSphereMetaData toBeChangedMetaData = new ShardingSphereMetaData(this.metaDataContexts.get().getMetaData().getDatabases(), this.metaDataContexts.get().getMetaData().getGlobalResourceMetaData(), this.metaDataContexts.get().getMetaData().getGlobalRuleMetaData(), this.metaDataContexts.get().getMetaData().getProps());
        this.metaDataContexts.set(this.newMetaDataContexts(toBeChangedMetaData));
    }

    private void closeStaleTransactionRule(RuleConfiguration ruleConfig) {
        YamlRuleConfiguration yamlRuleConfig = new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfiguration(ruleConfig);
        if (!"transaction".equals(Objects.requireNonNull(yamlRuleConfig.getClass().getAnnotation(RepositoryTupleEntity.class)).value())) {
            return;
        }
        Optional transactionRule = this.metaDataContexts.get().getMetaData().getGlobalRuleMetaData().findSingleRule(TransactionRule.class);
        if (transactionRule.isPresent()) {
            ((AutoCloseable)transactionRule.get()).close();
        }
    }

    public synchronized void alterProperties(Properties props) {
        ShardingSphereMetaData toBeChangedMetaData = new ShardingSphereMetaData(this.metaDataContexts.get().getMetaData().getDatabases(), this.metaDataContexts.get().getMetaData().getGlobalResourceMetaData(), this.metaDataContexts.get().getMetaData().getGlobalRuleMetaData(), new ConfigurationProperties(props));
        this.metaDataContexts.set(this.newMetaDataContexts(toBeChangedMetaData));
    }

    private MetaDataContexts newMetaDataContexts(ShardingSphereMetaData metaData) {
        return MetaDataContextsFactory.create(this.metaDataPersistService, metaData);
    }
}

