/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.listener;

import com.google.common.base.Preconditions;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.metadata.persist.node.metadata.DataSourceMetaDataNode;
import org.apache.shardingsphere.metadata.persist.node.metadata.TableMetaDataNode;
import org.apache.shardingsphere.metadata.persist.node.metadata.ViewMetaDataNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.builder.RuleConfigurationEventBuilder;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.datasource.node.AlterStorageNodeEvent;
import org.apache.shardingsphere.mode.event.dispatch.datasource.node.RegisterStorageNodeEvent;
import org.apache.shardingsphere.mode.event.dispatch.datasource.node.UnregisterStorageNodeEvent;
import org.apache.shardingsphere.mode.event.dispatch.datasource.unit.AlterStorageUnitEvent;
import org.apache.shardingsphere.mode.event.dispatch.datasource.unit.RegisterStorageUnitEvent;
import org.apache.shardingsphere.mode.event.dispatch.datasource.unit.UnregisterStorageUnitEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.SchemaAddedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.table.CreateOrAlterTableEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.table.DropTableEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.view.CreateOrAlterViewEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.schema.view.DropViewEvent;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;

public final class DatabaseMetaDataChangedListener
implements DataChangedEventListener {
    private final EventBusContext eventBusContext;
    private final RuleConfigurationEventBuilder builder = new RuleConfigurationEventBuilder();

    public void onChange(DataChangedEvent event) {
        this.createDispatchEvent(event).ifPresent(arg_0 -> ((EventBusContext)this.eventBusContext).post(arg_0));
    }

    private Optional<DispatchEvent> createDispatchEvent(DataChangedEvent event) {
        String key = event.getKey();
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameBySchemaNode((String)key);
        if (!databaseName.isPresent()) {
            return Optional.empty();
        }
        Optional schemaName = DatabaseMetaDataNode.getSchemaName((String)key);
        if (schemaName.isPresent()) {
            return this.createSchemaChangedEvent((String)databaseName.get(), (String)schemaName.get(), event);
        }
        schemaName = DatabaseMetaDataNode.getSchemaNameByTableNode((String)key);
        if (schemaName.isPresent() && this.tableMetaDataChanged(event.getKey())) {
            return this.createTableChangedEvent((String)databaseName.get(), (String)schemaName.get(), event);
        }
        if (schemaName.isPresent() && this.viewMetaDataChanged(event.getKey())) {
            return this.createViewChangedEvent((String)databaseName.get(), (String)schemaName.get(), event);
        }
        if (DataSourceMetaDataNode.isDataSourcesNode((String)key)) {
            return this.createDataSourceEvent((String)databaseName.get(), event);
        }
        return this.builder.build((String)databaseName.get(), event);
    }

    private Optional<DispatchEvent> createSchemaChangedEvent(String databaseName, String schemaName, DataChangedEvent event) {
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                return Optional.of(new SchemaAddedEvent(databaseName, schemaName));
            }
            case DELETED: {
                return Optional.of(new SchemaDeletedEvent(databaseName, schemaName));
            }
        }
        return Optional.empty();
    }

    private boolean tableMetaDataChanged(String key) {
        return TableMetaDataNode.isTableActiveVersionNode((String)key) || TableMetaDataNode.isTableNode((String)key);
    }

    private Optional<DispatchEvent> createTableChangedEvent(String databaseName, String schemaName, DataChangedEvent event) {
        if ((DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) && TableMetaDataNode.isTableActiveVersionNode((String)event.getKey())) {
            Optional tableName = TableMetaDataNode.getTableNameByActiveVersionNode((String)event.getKey());
            Preconditions.checkState((boolean)tableName.isPresent(), (Object)"Not found table name.");
            return Optional.of(new CreateOrAlterTableEvent(databaseName, schemaName, (String)tableName.get(), event.getKey(), event.getValue()));
        }
        if (DataChangedEvent.Type.DELETED == event.getType() && TableMetaDataNode.isTableNode((String)event.getKey())) {
            Optional tableName = TableMetaDataNode.getTableName((String)event.getKey());
            Preconditions.checkState((boolean)tableName.isPresent(), (Object)"Not found table name.");
            return Optional.of(new DropTableEvent(databaseName, schemaName, (String)tableName.get()));
        }
        return Optional.empty();
    }

    private boolean viewMetaDataChanged(String key) {
        return ViewMetaDataNode.isViewActiveVersionNode((String)key) || ViewMetaDataNode.isViewNode((String)key);
    }

    private Optional<DispatchEvent> createViewChangedEvent(String databaseName, String schemaName, DataChangedEvent event) {
        if ((DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) && ViewMetaDataNode.isViewActiveVersionNode((String)event.getKey())) {
            Optional viewName = ViewMetaDataNode.getViewNameByActiveVersionNode((String)event.getKey());
            Preconditions.checkState((boolean)viewName.isPresent(), (Object)"Not found view name.");
            return Optional.of(new CreateOrAlterViewEvent(databaseName, schemaName, (String)viewName.get(), event.getKey(), event.getValue()));
        }
        if (DataChangedEvent.Type.DELETED == event.getType() && ViewMetaDataNode.isViewNode((String)event.getKey())) {
            Optional viewName = ViewMetaDataNode.getViewName((String)event.getKey());
            Preconditions.checkState((boolean)viewName.isPresent(), (Object)"Not found view name.");
            return Optional.of(new DropViewEvent(databaseName, schemaName, (String)viewName.get(), event.getKey(), event.getValue()));
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> createDataSourceEvent(String databaseName, DataChangedEvent event) {
        if (DataSourceMetaDataNode.isDataSourceUnitActiveVersionNode((String)event.getKey()) || DataSourceMetaDataNode.isDataSourceUnitNode((String)event.getKey())) {
            return this.createStorageUnitChangedEvent(databaseName, event);
        }
        if (DataSourceMetaDataNode.isDataSourceNodeActiveVersionNode((String)event.getKey()) || DataSourceMetaDataNode.isDataSourceNodeNode((String)event.getKey())) {
            return this.createStorageNodeChangedEvent(databaseName, event);
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> createStorageUnitChangedEvent(String databaseName, DataChangedEvent event) {
        Optional dataSourceUnitName = DataSourceMetaDataNode.getDataSourceNameByDataSourceUnitActiveVersionNode((String)event.getKey());
        if (dataSourceUnitName.isPresent()) {
            if (DataChangedEvent.Type.ADDED == event.getType()) {
                return Optional.of(new RegisterStorageUnitEvent(databaseName, (String)dataSourceUnitName.get(), event.getKey(), event.getValue()));
            }
            if (DataChangedEvent.Type.UPDATED == event.getType()) {
                return Optional.of(new AlterStorageUnitEvent(databaseName, (String)dataSourceUnitName.get(), event.getKey(), event.getValue()));
            }
        }
        dataSourceUnitName = DataSourceMetaDataNode.getDataSourceNameByDataSourceUnitNode((String)event.getKey());
        if (DataChangedEvent.Type.DELETED == event.getType() && dataSourceUnitName.isPresent()) {
            return Optional.of(new UnregisterStorageUnitEvent(databaseName, (String)dataSourceUnitName.get()));
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> createStorageNodeChangedEvent(String databaseName, DataChangedEvent event) {
        Optional dataSourceNodeName = DataSourceMetaDataNode.getDataSourceNameByDataSourceNodeActiveVersionNode((String)event.getKey());
        if (dataSourceNodeName.isPresent()) {
            if (DataChangedEvent.Type.ADDED == event.getType()) {
                return Optional.of(new RegisterStorageNodeEvent(databaseName, (String)dataSourceNodeName.get(), event.getKey(), event.getValue()));
            }
            if (DataChangedEvent.Type.UPDATED == event.getType()) {
                return Optional.of(new AlterStorageNodeEvent(databaseName, (String)dataSourceNodeName.get(), event.getKey(), event.getValue()));
            }
        }
        dataSourceNodeName = DataSourceMetaDataNode.getDataSourceNameByDataSourceNodeNode((String)event.getKey());
        if (DataChangedEvent.Type.DELETED == event.getType() && dataSourceNodeName.isPresent()) {
            return Optional.of(new UnregisterStorageNodeEvent(databaseName, (String)dataSourceNodeName.get()));
        }
        return Optional.empty();
    }

    @Generated
    public DatabaseMetaDataChangedListener(EventBusContext eventBusContext) {
        this.eventBusContext = eventBusContext;
    }
}

