/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.subscriber.dispatch;

import com.google.common.eventbus.Subscribe;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.util.eventbus.EventSubscriber;
import org.apache.shardingsphere.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.event.dispatch.assisted.CreateDatabaseListenerAssistedEvent;
import org.apache.shardingsphere.mode.event.dispatch.assisted.DropDatabaseListenerAssistedEvent;
import org.apache.shardingsphere.mode.lock.GlobalLockContext;
import org.apache.shardingsphere.mode.lock.LockPersistService;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.listener.DatabaseMetaDataChangedListener;
import org.apache.shardingsphere.mode.manager.cluster.lock.GlobalLockPersistService;
import org.apache.shardingsphere.mode.metadata.refresher.ShardingSphereStatisticsRefreshEngine;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;

public final class ListenerAssistedSubscriber
implements EventSubscriber {
    private final ContextManager contextManager;
    private final ClusterPersistRepository repository;

    public ListenerAssistedSubscriber(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.repository = (ClusterPersistRepository)contextManager.getPersistServiceFacade().getRepository();
    }

    @Subscribe
    public synchronized void renew(CreateDatabaseListenerAssistedEvent event) {
        this.repository.watch(DatabaseMetaDataNode.getDatabaseNamePath((String)event.getDatabaseName()), (DataChangedEventListener)new DatabaseMetaDataChangedListener(this.contextManager.getComputeNodeInstanceContext().getEventBusContext()));
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().addDatabase(event.getDatabaseName());
        this.contextManager.getPersistServiceFacade().getListenerAssistedPersistService().deleteDatabaseNameListenerAssisted(event.getDatabaseName());
        this.refreshShardingSphereStatisticsData();
    }

    @Subscribe
    public synchronized void renew(DropDatabaseListenerAssistedEvent event) {
        this.repository.removeDataListener(DatabaseMetaDataNode.getDatabaseNamePath((String)event.getDatabaseName()));
        this.contextManager.getMetaDataContextManager().getSchemaMetaDataManager().dropDatabase(event.getDatabaseName());
        this.contextManager.getPersistServiceFacade().getListenerAssistedPersistService().deleteDatabaseNameListenerAssisted(event.getDatabaseName());
        this.refreshShardingSphereStatisticsData();
    }

    private void refreshShardingSphereStatisticsData() {
        if (this.contextManager.getComputeNodeInstanceContext().getModeConfiguration().isCluster() && InstanceType.PROXY == this.contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getType()) {
            new ShardingSphereStatisticsRefreshEngine(this.contextManager, new GlobalLockContext((LockPersistService)new GlobalLockPersistService(this.repository))).asyncRefresh();
        }
    }

    @Generated
    public ListenerAssistedSubscriber(ContextManager contextManager, ClusterPersistRepository repository) {
        this.contextManager = contextManager;
        this.repository = repository;
    }
}

