/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.rule.changed;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.apache.shardingsphere.broadcast.config.BroadcastRuleConfiguration;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;

public final class BroadcastTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<BroadcastRuleConfiguration, BroadcastRuleConfiguration> {
    public BroadcastRuleConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return new BroadcastRuleConfiguration((Collection)YamlEngine.unmarshal((String)yamlContent, LinkedHashSet.class));
    }

    public BroadcastRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(BroadcastRule.class).map(BroadcastRule::getConfiguration).orElseGet(() -> new BroadcastRuleConfiguration(new LinkedList()));
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, BroadcastRuleConfiguration currentRuleConfig, BroadcastRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().clear();
        currentRuleConfig.getTables().addAll(toBeChangedItemConfig.getTables());
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, BroadcastRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().clear();
    }

    public String getType() {
        return "broadcast.tables";
    }
}

