/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dml;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.shardingsphere.infra.binder.engine.segment.assign.AssignmentSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.from.TableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.where.WhereSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class UpdateStatementBinder
implements SQLStatementBinder<UpdateStatement> {
    @Override
    public UpdateStatement bind(UpdateStatement sqlStatement, SQLStatementBinderContext binderContext) {
        UpdateStatement result = this.copy(sqlStatement);
        LinkedHashMap<String, TableSegmentBinderContext> tableBinderContexts = new LinkedHashMap<String, TableSegmentBinderContext>();
        result.setTable(TableSegmentBinder.bind(sqlStatement.getTable(), binderContext, tableBinderContexts, Collections.emptyMap()));
        sqlStatement.getFrom().ifPresent(optional -> result.setFrom(TableSegmentBinder.bind(optional, binderContext, tableBinderContexts, Collections.emptyMap())));
        sqlStatement.getAssignmentSegment().ifPresent(optional -> result.setSetAssignment(AssignmentSegmentBinder.bind(optional, binderContext, tableBinderContexts, Collections.emptyMap())));
        sqlStatement.getWhere().ifPresent(optional -> result.setWhere(WhereSegmentBinder.bind(optional, binderContext, tableBinderContexts, Collections.emptyMap())));
        return result;
    }

    private UpdateStatement copy(UpdateStatement sqlStatement) {
        UpdateStatement result = (UpdateStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        sqlStatement.getOrderBy().ifPresent(arg_0 -> ((UpdateStatement)result).setOrderBy(arg_0));
        sqlStatement.getLimit().ifPresent(arg_0 -> ((UpdateStatement)result).setLimit(arg_0));
        sqlStatement.getWithSegment().ifPresent(arg_0 -> ((UpdateStatement)result).setWithSegment(arg_0));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        return result;
    }
}

