/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.aware.CursorAware;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingTableToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;

public final class ShardingTableTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
RouteContextAware {
    private final ShardingRule shardingRule;
    private RouteContext routeContext;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return !(sqlStatementContext instanceof CursorAware) && (this.isAllBindingTables(sqlStatementContext) || this.routeContext.containsTableSharding());
    }

    private boolean isAllBindingTables(SQLStatementContext sqlStatementContext) {
        List<String> shardingLogicTableNames = sqlStatementContext instanceof TableAvailable ? this.shardingRule.getShardingLogicTableNames(((TableAvailable)sqlStatementContext).getTablesContext().getTableNames()) : Collections.emptyList();
        return shardingLogicTableNames.size() > 1 && this.shardingRule.isAllBindingTables(shardingLogicTableNames);
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof TableAvailable ? this.generateSQLTokens((TableAvailable)sqlStatementContext) : Collections.emptyList();
    }

    private Collection<SQLToken> generateSQLTokens(TableAvailable sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (SimpleTableSegment each : sqlStatementContext.getTablesContext().getSimpleTables()) {
            TableNameSegment tableName = each.getTableName();
            if (!this.shardingRule.findShardingTable(tableName.getIdentifier().getValue()).isPresent()) continue;
            result.add(new ShardingTableToken(tableName.getStartIndex(), tableName.getStopIndex(), tableName.getIdentifier(), (SQLStatementContext)sqlStatementContext, this.shardingRule));
        }
        return result;
    }

    @Generated
    public ShardingTableTokenGenerator(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }

    @Generated
    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

