/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import java.util.Date;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDuration;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.DateRange;

@Immutable
public class CalendarDateRange {
    private final CalendarDate start;
    private final CalendarDate end;
    private final DateTime startDt;
    private final DateTime endDt;
    private final Calendar cal;

    public static CalendarDateRange of(CalendarDate start, CalendarDate end) {
        return new CalendarDateRange(start, end);
    }

    public static CalendarDateRange of(Date start, Date end) {
        return new CalendarDateRange(CalendarDate.of(start), CalendarDate.of(end));
    }

    private CalendarDateRange(CalendarDate start, CalendarDate end) {
        this.start = start;
        this.end = end;
        this.startDt = start.getDateTime();
        this.endDt = end.getDateTime();
        this.cal = start.getCalendar();
        assert (this.cal == end.getCalendar());
    }

    public CalendarDateRange(CalendarDate start, long durationInSecs) {
        this.start = start;
        this.end = start.add((int)durationInSecs, CalendarPeriod.Field.Second);
        this.startDt = start.getDateTime();
        this.endDt = this.end.getDateTime();
        this.cal = start.getCalendar();
    }

    public CalendarDate getStart() {
        return this.start;
    }

    public CalendarDate getEnd() {
        return this.end;
    }

    public long getDurationInSecs() {
        return (this.endDt.getMillis() - this.startDt.getMillis()) / 1000L;
    }

    public CalendarDuration getDuration() {
        return null;
    }

    public CalendarDuration getResolution() {
        return null;
    }

    public void setResolution() {
    }

    public boolean intersects(CalendarDateRange o) {
        return this.intersects(o.getStart(), o.getEnd());
    }

    public boolean intersects(CalendarDate start, CalendarDate end) {
        if (this.startDt.isAfter(end.getDateTime())) {
            return false;
        }
        return !this.endDt.isBefore(start.getDateTime());
    }

    public boolean includes(CalendarDate cd2) {
        DateTime dt = cd2.getDateTime();
        if (this.startDt.isAfter(dt)) {
            return false;
        }
        return !this.endDt.isBefore(dt);
    }

    public CalendarDateRange intersect(CalendarDateRange clip) {
        DateTime cs = clip.getStart().getDateTime();
        DateTime s2 = this.startDt.isBefore(cs) ? cs : this.startDt;
        DateTime ce = clip.getEnd().getDateTime();
        DateTime e = this.endDt.isBefore(ce) ? this.endDt : ce;
        return CalendarDateRange.of(CalendarDate.of(this.cal, s2), CalendarDate.of(this.cal, e));
    }

    public CalendarDateRange extend(CalendarDateRange other) {
        DateTime cs = other.getStart().getDateTime();
        DateTime s2 = this.startDt.isBefore(cs) ? this.startDt : cs;
        DateTime ce = other.getEnd().getDateTime();
        DateTime e = this.endDt.isBefore(ce) ? ce : this.endDt;
        return CalendarDateRange.of(CalendarDate.of(this.cal, s2), CalendarDate.of(this.cal, e));
    }

    public boolean isPoint() {
        return this.start.equals(this.end);
    }

    public String toString() {
        return this.start + " - " + this.end;
    }

    public static CalendarDateRange of(DateRange dr) {
        if (dr == null) {
            return null;
        }
        return CalendarDateRange.of(dr.getStart().getDate(), dr.getEnd().getDate());
    }

    public DateRange toDateRange() {
        return new DateRange(this.start.toDate(), this.end.toDate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarDateRange that = (CalendarDateRange)o;
        return this.start.equals(that.start) && this.end.equals(that.end);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        return result;
    }
}

