/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CompositeInputSplit
extends InputSplit
implements Writable {
    private int fill = 0;
    private long totsize = 0L;
    private InputSplit[] splits;
    private Configuration conf = new Configuration();

    public CompositeInputSplit() {
    }

    public CompositeInputSplit(int capacity) {
        this.splits = new InputSplit[capacity];
    }

    public void add(InputSplit s2) throws IOException, InterruptedException {
        if (null == this.splits) {
            throw new IOException("Uninitialized InputSplit");
        }
        if (this.fill == this.splits.length) {
            throw new IOException("Too many splits");
        }
        this.splits[this.fill++] = s2;
        this.totsize += s2.getLength();
    }

    public InputSplit get(int i) {
        return this.splits[i];
    }

    @Override
    public long getLength() throws IOException {
        return this.totsize;
    }

    public long getLength(int i) throws IOException, InterruptedException {
        return this.splits[i].getLength();
    }

    @Override
    public String[] getLocations() throws IOException, InterruptedException {
        HashSet<String> hosts = new HashSet<String>();
        for (InputSplit s2 : this.splits) {
            String[] hints = s2.getLocations();
            if (hints == null || hints.length <= 0) continue;
            for (String host : hints) {
                hosts.add(host);
            }
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    public String[] getLocation(int i) throws IOException, InterruptedException {
        return this.splits[i].getLocations();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.splits.length);
        for (InputSplit s2 : this.splits) {
            Text.writeString(out, s2.getClass().getName());
        }
        for (InputSplit s2 : this.splits) {
            SerializationFactory factory = new SerializationFactory(this.conf);
            Serializer<?> serializer = factory.getSerializer(s2.getClass());
            serializer.open((DataOutputStream)out);
            serializer.serialize(s2);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int card = WritableUtils.readVInt(in);
        if (this.splits == null || this.splits.length != card) {
            this.splits = new InputSplit[card];
        }
        Class[] cls = new Class[card];
        try {
            int i;
            for (i = 0; i < card; ++i) {
                cls[i] = Class.forName(Text.readString(in)).asSubclass(InputSplit.class);
            }
            for (i = 0; i < card; ++i) {
                this.splits[i] = (InputSplit)ReflectionUtils.newInstance(cls[i], null);
                SerializationFactory factory = new SerializationFactory(this.conf);
                Deserializer<InputSplit> deserializer = factory.getDeserializer(cls[i]);
                deserializer.open((DataInputStream)in);
                this.splits[i] = deserializer.deserialize(this.splits[i]);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed split init", e);
        }
    }
}

