/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeOption;
import org.apache.seatunnel.connectors.seatunnel.fake.exception.FakeConnectorException;

public class FakeConfig
implements Serializable {
    private int rowNum;
    private int splitNum;
    private int splitReadInterval;
    private int mapSize;
    private int arraySize;
    private int bytesLength;
    private int stringLength;
    private int tinyintMin;
    private int tinyintMax;
    private int smallintMin;
    private int smallintMax;
    private int intMin;
    private int intMax;
    private long bigintMin;
    private long bigintMax;
    private double floatMin;
    private double floatMax;
    private double doubleMin;
    private double doubleMax;
    private float vectorFloatMin;
    private float vectorFloatMax;
    private int vectorDimension;
    private int binaryVectorDimension;
    private FakeOption.FakeMode stringFakeMode;
    private FakeOption.FakeMode tinyintFakeMode;
    private FakeOption.FakeMode smallintFakeMode;
    private FakeOption.FakeMode intFakeMode;
    private FakeOption.FakeMode bigintFakeMode;
    private FakeOption.FakeMode floatFakeMode;
    private FakeOption.FakeMode doubleFakeMode;
    private List<String> stringTemplate;
    private List<Integer> tinyintTemplate;
    private List<Integer> smallintTemplate;
    private List<Integer> intTemplate;
    private List<Long> bigTemplate;
    private List<Double> floatTemplate;
    private List<Double> doubleTemplate;
    private List<Integer> dateYearTemplate;
    private List<Integer> dateMonthTemplate;
    private List<Integer> dateDayTemplate;
    private List<Integer> timeHourTemplate;
    private List<Integer> timeMinuteTemplate;
    private List<Integer> timeSecondTemplate;
    private List<RowData> fakeRows;
    private CatalogTable catalogTable;

    public static FakeConfig buildWithConfig(ReadonlyConfig readonlyConfig) {
        FakeConfigBuilder builder = FakeConfig.builder();
        builder.rowNum((Integer)readonlyConfig.get(FakeOption.ROW_NUM));
        builder.splitNum((Integer)readonlyConfig.get(FakeOption.SPLIT_NUM));
        builder.splitReadInterval((Integer)readonlyConfig.get(FakeOption.SPLIT_READ_INTERVAL));
        builder.mapSize((Integer)readonlyConfig.get(FakeOption.MAP_SIZE));
        builder.arraySize((Integer)readonlyConfig.get(FakeOption.ARRAY_SIZE));
        builder.vectorDimension((Integer)readonlyConfig.get(FakeOption.VECTOR_DIMENSION));
        builder.binaryVectorDimension((Integer)readonlyConfig.get(FakeOption.BINARY_VECTOR_DIMENSION));
        builder.bytesLength((Integer)readonlyConfig.get(FakeOption.BYTES_LENGTH));
        builder.stringLength((Integer)readonlyConfig.get(FakeOption.STRING_LENGTH));
        if (readonlyConfig.getOptional(FakeOption.ROWS).isPresent()) {
            List configs = (List)readonlyConfig.get(FakeOption.ROWS);
            ArrayList<RowData> rows = new ArrayList<RowData>(configs.size());
            for (Map configItem : configs) {
                String fieldsJson = JsonUtils.toJsonString(configItem.get("fields"));
                RowData rowData = new RowData(configItem.get("kind").toString(), fieldsJson);
                rows.add(rowData);
            }
            builder.fakeRows(rows);
        }
        readonlyConfig.getOptional(FakeOption.STRING_TEMPLATE).ifPresent(builder::stringTemplate);
        readonlyConfig.getOptional(FakeOption.TINYINT_TEMPLATE).ifPresent(builder::tinyintTemplate);
        readonlyConfig.getOptional(FakeOption.SMALLINT_TEMPLATE).ifPresent(builder::smallintTemplate);
        readonlyConfig.getOptional(FakeOption.INT_TEMPLATE).ifPresent(builder::intTemplate);
        readonlyConfig.getOptional(FakeOption.BIGINT_TEMPLATE).ifPresent(builder::bigTemplate);
        readonlyConfig.getOptional(FakeOption.FLOAT_TEMPLATE).ifPresent(builder::floatTemplate);
        readonlyConfig.getOptional(FakeOption.DOUBLE_TEMPLATE).ifPresent(builder::doubleTemplate);
        readonlyConfig.getOptional(FakeOption.DATE_YEAR_TEMPLATE).ifPresent(builder::dateYearTemplate);
        readonlyConfig.getOptional(FakeOption.DATE_MONTH_TEMPLATE).ifPresent(builder::dateMonthTemplate);
        readonlyConfig.getOptional(FakeOption.DATE_DAY_TEMPLATE).ifPresent(builder::dateDayTemplate);
        readonlyConfig.getOptional(FakeOption.TIME_HOUR_TEMPLATE).ifPresent(builder::timeHourTemplate);
        readonlyConfig.getOptional(FakeOption.TIME_MINUTE_TEMPLATE).ifPresent(builder::timeMinuteTemplate);
        readonlyConfig.getOptional(FakeOption.TIME_SECOND_TEMPLATE).ifPresent(builder::timeSecondTemplate);
        readonlyConfig.getOptional(FakeOption.TINYINT_MIN).ifPresent(tinyintMin -> {
            if (tinyintMin < (Integer)FakeOption.TINYINT_MIN.defaultValue() || tinyintMin > (Integer)FakeOption.TINYINT_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.TINYINT_MIN.key() + " should >= " + FakeOption.TINYINT_MIN.defaultValue() + " and <= " + FakeOption.TINYINT_MAX.defaultValue());
            }
            builder.tinyintMin((int)tinyintMin);
        });
        readonlyConfig.getOptional(FakeOption.TINYINT_MAX).ifPresent(tinyintMax -> {
            if (tinyintMax < (Integer)FakeOption.TINYINT_MIN.defaultValue() || tinyintMax > (Integer)FakeOption.TINYINT_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.TINYINT_MAX.key() + " should >= " + FakeOption.TINYINT_MIN.defaultValue() + " and <= " + FakeOption.TINYINT_MAX.defaultValue());
            }
            builder.tinyintMax((int)tinyintMax);
        });
        readonlyConfig.getOptional(FakeOption.SMALLINT_MIN).ifPresent(smallintMin -> {
            if (smallintMin < (Integer)FakeOption.SMALLINT_MIN.defaultValue() || smallintMin > (Integer)FakeOption.SMALLINT_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.SMALLINT_MIN.key() + " should >= " + FakeOption.SMALLINT_MIN.defaultValue() + " and <= " + FakeOption.SMALLINT_MAX.defaultValue());
            }
            builder.smallintMin((int)smallintMin);
        });
        readonlyConfig.getOptional(FakeOption.SMALLINT_MAX).ifPresent(smallintMax -> {
            if (smallintMax < (Integer)FakeOption.SMALLINT_MIN.defaultValue() || smallintMax > (Integer)FakeOption.SMALLINT_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.SMALLINT_MAX.key() + " should >= " + FakeOption.SMALLINT_MIN.defaultValue() + " and <= " + FakeOption.SMALLINT_MAX.defaultValue());
            }
            builder.smallintMax((int)smallintMax);
        });
        readonlyConfig.getOptional(FakeOption.INT_MIN).ifPresent(intMin -> {
            if (intMin < (Integer)FakeOption.INT_MIN.defaultValue() || intMin > (Integer)FakeOption.INT_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.INT_MIN.key() + " should >= " + FakeOption.INT_MIN.defaultValue() + " and <= " + FakeOption.INT_MAX.defaultValue());
            }
            builder.intMin((int)intMin);
        });
        readonlyConfig.getOptional(FakeOption.INT_MAX).ifPresent(intMax -> {
            if (intMax < (Integer)FakeOption.INT_MIN.defaultValue() || intMax > (Integer)FakeOption.INT_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.INT_MAX.key() + " should >= " + FakeOption.INT_MIN.defaultValue() + " and <= " + FakeOption.INT_MAX.defaultValue());
            }
            builder.intMax((int)intMax);
        });
        readonlyConfig.getOptional(FakeOption.BIGINT_MIN).ifPresent(bigintMin -> {
            if (bigintMin < (Long)FakeOption.BIGINT_MIN.defaultValue() || bigintMin > (Long)FakeOption.BIGINT_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.BIGINT_MIN.key() + " should >= " + FakeOption.BIGINT_MIN.defaultValue() + " and <= " + FakeOption.BIGINT_MAX.defaultValue());
            }
            builder.bigintMin((long)bigintMin);
        });
        readonlyConfig.getOptional(FakeOption.BIGINT_MAX).ifPresent(bigintMax -> {
            if (bigintMax < (Long)FakeOption.BIGINT_MIN.defaultValue() || bigintMax > (Long)FakeOption.BIGINT_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.BIGINT_MAX.key() + " should >= " + FakeOption.BIGINT_MIN.defaultValue() + " and <= " + FakeOption.BIGINT_MAX.defaultValue());
            }
            builder.bigintMax((long)bigintMax);
        });
        readonlyConfig.getOptional(FakeOption.FLOAT_MIN).ifPresent(floatMin -> {
            if (floatMin.floatValue() < ((Float)FakeOption.FLOAT_MIN.defaultValue()).floatValue() || floatMin.floatValue() > ((Float)FakeOption.FLOAT_MAX.defaultValue()).floatValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.FLOAT_MIN.key() + " should >= " + FakeOption.FLOAT_MIN.defaultValue() + " and <= " + FakeOption.FLOAT_MAX.defaultValue());
            }
            builder.floatMin(floatMin.floatValue());
        });
        readonlyConfig.getOptional(FakeOption.FLOAT_MAX).ifPresent(floatMax -> {
            if (floatMax.floatValue() < ((Float)FakeOption.FLOAT_MIN.defaultValue()).floatValue() || floatMax.floatValue() > ((Float)FakeOption.FLOAT_MAX.defaultValue()).floatValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.FLOAT_MAX.key() + " should >= " + FakeOption.FLOAT_MIN.defaultValue() + " and <= " + FakeOption.FLOAT_MAX.defaultValue());
            }
            builder.floatMax(floatMax.floatValue());
        });
        readonlyConfig.getOptional(FakeOption.DOUBLE_MIN).ifPresent(doubleMin -> {
            if (doubleMin < (Double)FakeOption.DOUBLE_MIN.defaultValue() || doubleMin > (Double)FakeOption.DOUBLE_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.DOUBLE_MIN.key() + " should >= " + FakeOption.DOUBLE_MIN.defaultValue() + " and <= " + FakeOption.DOUBLE_MAX.defaultValue());
            }
            builder.doubleMin((double)doubleMin);
        });
        readonlyConfig.getOptional(FakeOption.DOUBLE_MAX).ifPresent(doubleMax -> {
            if (doubleMax < (Double)FakeOption.DOUBLE_MIN.defaultValue() || doubleMax > (Double)FakeOption.DOUBLE_MAX.defaultValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.DOUBLE_MAX.key() + " should >= " + FakeOption.DOUBLE_MIN.defaultValue() + " and <= " + FakeOption.DOUBLE_MAX.defaultValue());
            }
            builder.doubleMax((double)doubleMax);
        });
        readonlyConfig.getOptional(FakeOption.VECTOR_FLOAT_MIN).ifPresent(vectorFloatMin -> {
            if (vectorFloatMin.floatValue() < ((Float)FakeOption.VECTOR_FLOAT_MIN.defaultValue()).floatValue() || vectorFloatMin.floatValue() > ((Float)FakeOption.VECTOR_FLOAT_MAX.defaultValue()).floatValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.VECTOR_FLOAT_MIN.key() + " should >= " + FakeOption.VECTOR_FLOAT_MIN.defaultValue() + " and <= " + FakeOption.VECTOR_FLOAT_MAX.defaultValue());
            }
            builder.vectorFloatMin(vectorFloatMin.floatValue());
        });
        readonlyConfig.getOptional(FakeOption.VECTOR_FLOAT_MAX).ifPresent(vectorFloatMax -> {
            if (vectorFloatMax.floatValue() < ((Float)FakeOption.VECTOR_FLOAT_MIN.defaultValue()).floatValue() || vectorFloatMax.floatValue() > ((Float)FakeOption.VECTOR_FLOAT_MAX.defaultValue()).floatValue()) {
                throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, FakeOption.VECTOR_FLOAT_MAX.key() + " should >= " + FakeOption.VECTOR_FLOAT_MIN.defaultValue() + " and <= " + FakeOption.VECTOR_FLOAT_MAX.defaultValue());
            }
            builder.vectorFloatMax(vectorFloatMax.floatValue());
        });
        readonlyConfig.getOptional(FakeOption.STRING_FAKE_MODE).ifPresent(builder::stringFakeMode);
        readonlyConfig.getOptional(FakeOption.TINYINT_FAKE_MODE).ifPresent(builder::tinyintFakeMode);
        readonlyConfig.getOptional(FakeOption.SMALLINT_FAKE_MODE).ifPresent(builder::smallintFakeMode);
        readonlyConfig.getOptional(FakeOption.INT_FAKE_MODE).ifPresent(builder::intFakeMode);
        readonlyConfig.getOptional(FakeOption.BIGINT_FAKE_MODE).ifPresent(builder::bigintFakeMode);
        readonlyConfig.getOptional(FakeOption.FLOAT_FAKE_MODE).ifPresent(builder::floatFakeMode);
        readonlyConfig.getOptional(FakeOption.DOUBLE_FAKE_MODE).ifPresent(builder::doubleFakeMode);
        builder.catalogTable(CatalogTableUtil.buildWithConfig((String)"FakeSource", (ReadonlyConfig)readonlyConfig));
        return builder.build();
    }

    private static int $default$rowNum() {
        return (Integer)FakeOption.ROW_NUM.defaultValue();
    }

    private static int $default$splitNum() {
        return (Integer)FakeOption.SPLIT_NUM.defaultValue();
    }

    private static int $default$splitReadInterval() {
        return (Integer)FakeOption.SPLIT_READ_INTERVAL.defaultValue();
    }

    private static int $default$mapSize() {
        return (Integer)FakeOption.MAP_SIZE.defaultValue();
    }

    private static int $default$arraySize() {
        return (Integer)FakeOption.ARRAY_SIZE.defaultValue();
    }

    private static int $default$bytesLength() {
        return (Integer)FakeOption.BYTES_LENGTH.defaultValue();
    }

    private static int $default$stringLength() {
        return (Integer)FakeOption.STRING_LENGTH.defaultValue();
    }

    private static int $default$tinyintMin() {
        return (Integer)FakeOption.TINYINT_MIN.defaultValue();
    }

    private static int $default$tinyintMax() {
        return (Integer)FakeOption.TINYINT_MAX.defaultValue();
    }

    private static int $default$smallintMin() {
        return (Integer)FakeOption.SMALLINT_MIN.defaultValue();
    }

    private static int $default$smallintMax() {
        return (Integer)FakeOption.SMALLINT_MAX.defaultValue();
    }

    private static int $default$intMin() {
        return (Integer)FakeOption.INT_MIN.defaultValue();
    }

    private static int $default$intMax() {
        return (Integer)FakeOption.INT_MAX.defaultValue();
    }

    private static long $default$bigintMin() {
        return (Long)FakeOption.BIGINT_MIN.defaultValue();
    }

    private static long $default$bigintMax() {
        return (Long)FakeOption.BIGINT_MAX.defaultValue();
    }

    private static double $default$floatMin() {
        return ((Float)FakeOption.FLOAT_MIN.defaultValue()).floatValue();
    }

    private static double $default$floatMax() {
        return ((Float)FakeOption.FLOAT_MAX.defaultValue()).floatValue();
    }

    private static double $default$doubleMin() {
        return (Double)FakeOption.DOUBLE_MIN.defaultValue();
    }

    private static double $default$doubleMax() {
        return (Double)FakeOption.DOUBLE_MAX.defaultValue();
    }

    private static float $default$vectorFloatMin() {
        return ((Float)FakeOption.VECTOR_FLOAT_MIN.defaultValue()).floatValue();
    }

    private static float $default$vectorFloatMax() {
        return ((Float)FakeOption.VECTOR_FLOAT_MAX.defaultValue()).floatValue();
    }

    private static int $default$vectorDimension() {
        return (Integer)FakeOption.VECTOR_DIMENSION.defaultValue();
    }

    private static int $default$binaryVectorDimension() {
        return (Integer)FakeOption.BINARY_VECTOR_DIMENSION.defaultValue();
    }

    private static FakeOption.FakeMode $default$stringFakeMode() {
        return (FakeOption.FakeMode)((Object)FakeOption.STRING_FAKE_MODE.defaultValue());
    }

    private static FakeOption.FakeMode $default$tinyintFakeMode() {
        return (FakeOption.FakeMode)((Object)FakeOption.TINYINT_FAKE_MODE.defaultValue());
    }

    private static FakeOption.FakeMode $default$smallintFakeMode() {
        return (FakeOption.FakeMode)((Object)FakeOption.SMALLINT_FAKE_MODE.defaultValue());
    }

    private static FakeOption.FakeMode $default$intFakeMode() {
        return (FakeOption.FakeMode)((Object)FakeOption.INT_FAKE_MODE.defaultValue());
    }

    private static FakeOption.FakeMode $default$bigintFakeMode() {
        return (FakeOption.FakeMode)((Object)FakeOption.BIGINT_FAKE_MODE.defaultValue());
    }

    private static FakeOption.FakeMode $default$floatFakeMode() {
        return (FakeOption.FakeMode)((Object)FakeOption.FLOAT_FAKE_MODE.defaultValue());
    }

    private static FakeOption.FakeMode $default$doubleFakeMode() {
        return (FakeOption.FakeMode)((Object)FakeOption.DOUBLE_FAKE_MODE.defaultValue());
    }

    FakeConfig(int rowNum, int splitNum, int splitReadInterval, int mapSize, int arraySize, int bytesLength, int stringLength, int tinyintMin, int tinyintMax, int smallintMin, int smallintMax, int intMin, int intMax, long bigintMin, long bigintMax, double floatMin, double floatMax, double doubleMin, double doubleMax, float vectorFloatMin, float vectorFloatMax, int vectorDimension, int binaryVectorDimension, FakeOption.FakeMode stringFakeMode, FakeOption.FakeMode tinyintFakeMode, FakeOption.FakeMode smallintFakeMode, FakeOption.FakeMode intFakeMode, FakeOption.FakeMode bigintFakeMode, FakeOption.FakeMode floatFakeMode, FakeOption.FakeMode doubleFakeMode, List<String> stringTemplate, List<Integer> tinyintTemplate, List<Integer> smallintTemplate, List<Integer> intTemplate, List<Long> bigTemplate, List<Double> floatTemplate, List<Double> doubleTemplate, List<Integer> dateYearTemplate, List<Integer> dateMonthTemplate, List<Integer> dateDayTemplate, List<Integer> timeHourTemplate, List<Integer> timeMinuteTemplate, List<Integer> timeSecondTemplate, List<RowData> fakeRows, CatalogTable catalogTable) {
        this.rowNum = rowNum;
        this.splitNum = splitNum;
        this.splitReadInterval = splitReadInterval;
        this.mapSize = mapSize;
        this.arraySize = arraySize;
        this.bytesLength = bytesLength;
        this.stringLength = stringLength;
        this.tinyintMin = tinyintMin;
        this.tinyintMax = tinyintMax;
        this.smallintMin = smallintMin;
        this.smallintMax = smallintMax;
        this.intMin = intMin;
        this.intMax = intMax;
        this.bigintMin = bigintMin;
        this.bigintMax = bigintMax;
        this.floatMin = floatMin;
        this.floatMax = floatMax;
        this.doubleMin = doubleMin;
        this.doubleMax = doubleMax;
        this.vectorFloatMin = vectorFloatMin;
        this.vectorFloatMax = vectorFloatMax;
        this.vectorDimension = vectorDimension;
        this.binaryVectorDimension = binaryVectorDimension;
        this.stringFakeMode = stringFakeMode;
        this.tinyintFakeMode = tinyintFakeMode;
        this.smallintFakeMode = smallintFakeMode;
        this.intFakeMode = intFakeMode;
        this.bigintFakeMode = bigintFakeMode;
        this.floatFakeMode = floatFakeMode;
        this.doubleFakeMode = doubleFakeMode;
        this.stringTemplate = stringTemplate;
        this.tinyintTemplate = tinyintTemplate;
        this.smallintTemplate = smallintTemplate;
        this.intTemplate = intTemplate;
        this.bigTemplate = bigTemplate;
        this.floatTemplate = floatTemplate;
        this.doubleTemplate = doubleTemplate;
        this.dateYearTemplate = dateYearTemplate;
        this.dateMonthTemplate = dateMonthTemplate;
        this.dateDayTemplate = dateDayTemplate;
        this.timeHourTemplate = timeHourTemplate;
        this.timeMinuteTemplate = timeMinuteTemplate;
        this.timeSecondTemplate = timeSecondTemplate;
        this.fakeRows = fakeRows;
        this.catalogTable = catalogTable;
    }

    public static FakeConfigBuilder builder() {
        return new FakeConfigBuilder();
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public int getSplitNum() {
        return this.splitNum;
    }

    public int getSplitReadInterval() {
        return this.splitReadInterval;
    }

    public int getMapSize() {
        return this.mapSize;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public int getBytesLength() {
        return this.bytesLength;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public int getTinyintMin() {
        return this.tinyintMin;
    }

    public int getTinyintMax() {
        return this.tinyintMax;
    }

    public int getSmallintMin() {
        return this.smallintMin;
    }

    public int getSmallintMax() {
        return this.smallintMax;
    }

    public int getIntMin() {
        return this.intMin;
    }

    public int getIntMax() {
        return this.intMax;
    }

    public long getBigintMin() {
        return this.bigintMin;
    }

    public long getBigintMax() {
        return this.bigintMax;
    }

    public double getFloatMin() {
        return this.floatMin;
    }

    public double getFloatMax() {
        return this.floatMax;
    }

    public double getDoubleMin() {
        return this.doubleMin;
    }

    public double getDoubleMax() {
        return this.doubleMax;
    }

    public float getVectorFloatMin() {
        return this.vectorFloatMin;
    }

    public float getVectorFloatMax() {
        return this.vectorFloatMax;
    }

    public int getVectorDimension() {
        return this.vectorDimension;
    }

    public int getBinaryVectorDimension() {
        return this.binaryVectorDimension;
    }

    public FakeOption.FakeMode getStringFakeMode() {
        return this.stringFakeMode;
    }

    public FakeOption.FakeMode getTinyintFakeMode() {
        return this.tinyintFakeMode;
    }

    public FakeOption.FakeMode getSmallintFakeMode() {
        return this.smallintFakeMode;
    }

    public FakeOption.FakeMode getIntFakeMode() {
        return this.intFakeMode;
    }

    public FakeOption.FakeMode getBigintFakeMode() {
        return this.bigintFakeMode;
    }

    public FakeOption.FakeMode getFloatFakeMode() {
        return this.floatFakeMode;
    }

    public FakeOption.FakeMode getDoubleFakeMode() {
        return this.doubleFakeMode;
    }

    public List<String> getStringTemplate() {
        return this.stringTemplate;
    }

    public List<Integer> getTinyintTemplate() {
        return this.tinyintTemplate;
    }

    public List<Integer> getSmallintTemplate() {
        return this.smallintTemplate;
    }

    public List<Integer> getIntTemplate() {
        return this.intTemplate;
    }

    public List<Long> getBigTemplate() {
        return this.bigTemplate;
    }

    public List<Double> getFloatTemplate() {
        return this.floatTemplate;
    }

    public List<Double> getDoubleTemplate() {
        return this.doubleTemplate;
    }

    public List<Integer> getDateYearTemplate() {
        return this.dateYearTemplate;
    }

    public List<Integer> getDateMonthTemplate() {
        return this.dateMonthTemplate;
    }

    public List<Integer> getDateDayTemplate() {
        return this.dateDayTemplate;
    }

    public List<Integer> getTimeHourTemplate() {
        return this.timeHourTemplate;
    }

    public List<Integer> getTimeMinuteTemplate() {
        return this.timeMinuteTemplate;
    }

    public List<Integer> getTimeSecondTemplate() {
        return this.timeSecondTemplate;
    }

    public List<RowData> getFakeRows() {
        return this.fakeRows;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public static class FakeConfigBuilder {
        private boolean rowNum$set;
        private int rowNum$value;
        private boolean splitNum$set;
        private int splitNum$value;
        private boolean splitReadInterval$set;
        private int splitReadInterval$value;
        private boolean mapSize$set;
        private int mapSize$value;
        private boolean arraySize$set;
        private int arraySize$value;
        private boolean bytesLength$set;
        private int bytesLength$value;
        private boolean stringLength$set;
        private int stringLength$value;
        private boolean tinyintMin$set;
        private int tinyintMin$value;
        private boolean tinyintMax$set;
        private int tinyintMax$value;
        private boolean smallintMin$set;
        private int smallintMin$value;
        private boolean smallintMax$set;
        private int smallintMax$value;
        private boolean intMin$set;
        private int intMin$value;
        private boolean intMax$set;
        private int intMax$value;
        private boolean bigintMin$set;
        private long bigintMin$value;
        private boolean bigintMax$set;
        private long bigintMax$value;
        private boolean floatMin$set;
        private double floatMin$value;
        private boolean floatMax$set;
        private double floatMax$value;
        private boolean doubleMin$set;
        private double doubleMin$value;
        private boolean doubleMax$set;
        private double doubleMax$value;
        private boolean vectorFloatMin$set;
        private float vectorFloatMin$value;
        private boolean vectorFloatMax$set;
        private float vectorFloatMax$value;
        private boolean vectorDimension$set;
        private int vectorDimension$value;
        private boolean binaryVectorDimension$set;
        private int binaryVectorDimension$value;
        private boolean stringFakeMode$set;
        private FakeOption.FakeMode stringFakeMode$value;
        private boolean tinyintFakeMode$set;
        private FakeOption.FakeMode tinyintFakeMode$value;
        private boolean smallintFakeMode$set;
        private FakeOption.FakeMode smallintFakeMode$value;
        private boolean intFakeMode$set;
        private FakeOption.FakeMode intFakeMode$value;
        private boolean bigintFakeMode$set;
        private FakeOption.FakeMode bigintFakeMode$value;
        private boolean floatFakeMode$set;
        private FakeOption.FakeMode floatFakeMode$value;
        private boolean doubleFakeMode$set;
        private FakeOption.FakeMode doubleFakeMode$value;
        private List<String> stringTemplate;
        private List<Integer> tinyintTemplate;
        private List<Integer> smallintTemplate;
        private List<Integer> intTemplate;
        private List<Long> bigTemplate;
        private List<Double> floatTemplate;
        private List<Double> doubleTemplate;
        private List<Integer> dateYearTemplate;
        private List<Integer> dateMonthTemplate;
        private List<Integer> dateDayTemplate;
        private List<Integer> timeHourTemplate;
        private List<Integer> timeMinuteTemplate;
        private List<Integer> timeSecondTemplate;
        private List<RowData> fakeRows;
        private CatalogTable catalogTable;

        FakeConfigBuilder() {
        }

        public FakeConfigBuilder rowNum(int rowNum) {
            this.rowNum$value = rowNum;
            this.rowNum$set = true;
            return this;
        }

        public FakeConfigBuilder splitNum(int splitNum) {
            this.splitNum$value = splitNum;
            this.splitNum$set = true;
            return this;
        }

        public FakeConfigBuilder splitReadInterval(int splitReadInterval) {
            this.splitReadInterval$value = splitReadInterval;
            this.splitReadInterval$set = true;
            return this;
        }

        public FakeConfigBuilder mapSize(int mapSize) {
            this.mapSize$value = mapSize;
            this.mapSize$set = true;
            return this;
        }

        public FakeConfigBuilder arraySize(int arraySize) {
            this.arraySize$value = arraySize;
            this.arraySize$set = true;
            return this;
        }

        public FakeConfigBuilder bytesLength(int bytesLength) {
            this.bytesLength$value = bytesLength;
            this.bytesLength$set = true;
            return this;
        }

        public FakeConfigBuilder stringLength(int stringLength) {
            this.stringLength$value = stringLength;
            this.stringLength$set = true;
            return this;
        }

        public FakeConfigBuilder tinyintMin(int tinyintMin) {
            this.tinyintMin$value = tinyintMin;
            this.tinyintMin$set = true;
            return this;
        }

        public FakeConfigBuilder tinyintMax(int tinyintMax) {
            this.tinyintMax$value = tinyintMax;
            this.tinyintMax$set = true;
            return this;
        }

        public FakeConfigBuilder smallintMin(int smallintMin) {
            this.smallintMin$value = smallintMin;
            this.smallintMin$set = true;
            return this;
        }

        public FakeConfigBuilder smallintMax(int smallintMax) {
            this.smallintMax$value = smallintMax;
            this.smallintMax$set = true;
            return this;
        }

        public FakeConfigBuilder intMin(int intMin) {
            this.intMin$value = intMin;
            this.intMin$set = true;
            return this;
        }

        public FakeConfigBuilder intMax(int intMax) {
            this.intMax$value = intMax;
            this.intMax$set = true;
            return this;
        }

        public FakeConfigBuilder bigintMin(long bigintMin) {
            this.bigintMin$value = bigintMin;
            this.bigintMin$set = true;
            return this;
        }

        public FakeConfigBuilder bigintMax(long bigintMax) {
            this.bigintMax$value = bigintMax;
            this.bigintMax$set = true;
            return this;
        }

        public FakeConfigBuilder floatMin(double floatMin) {
            this.floatMin$value = floatMin;
            this.floatMin$set = true;
            return this;
        }

        public FakeConfigBuilder floatMax(double floatMax) {
            this.floatMax$value = floatMax;
            this.floatMax$set = true;
            return this;
        }

        public FakeConfigBuilder doubleMin(double doubleMin) {
            this.doubleMin$value = doubleMin;
            this.doubleMin$set = true;
            return this;
        }

        public FakeConfigBuilder doubleMax(double doubleMax) {
            this.doubleMax$value = doubleMax;
            this.doubleMax$set = true;
            return this;
        }

        public FakeConfigBuilder vectorFloatMin(float vectorFloatMin) {
            this.vectorFloatMin$value = vectorFloatMin;
            this.vectorFloatMin$set = true;
            return this;
        }

        public FakeConfigBuilder vectorFloatMax(float vectorFloatMax) {
            this.vectorFloatMax$value = vectorFloatMax;
            this.vectorFloatMax$set = true;
            return this;
        }

        public FakeConfigBuilder vectorDimension(int vectorDimension) {
            this.vectorDimension$value = vectorDimension;
            this.vectorDimension$set = true;
            return this;
        }

        public FakeConfigBuilder binaryVectorDimension(int binaryVectorDimension) {
            this.binaryVectorDimension$value = binaryVectorDimension;
            this.binaryVectorDimension$set = true;
            return this;
        }

        public FakeConfigBuilder stringFakeMode(FakeOption.FakeMode stringFakeMode) {
            this.stringFakeMode$value = stringFakeMode;
            this.stringFakeMode$set = true;
            return this;
        }

        public FakeConfigBuilder tinyintFakeMode(FakeOption.FakeMode tinyintFakeMode) {
            this.tinyintFakeMode$value = tinyintFakeMode;
            this.tinyintFakeMode$set = true;
            return this;
        }

        public FakeConfigBuilder smallintFakeMode(FakeOption.FakeMode smallintFakeMode) {
            this.smallintFakeMode$value = smallintFakeMode;
            this.smallintFakeMode$set = true;
            return this;
        }

        public FakeConfigBuilder intFakeMode(FakeOption.FakeMode intFakeMode) {
            this.intFakeMode$value = intFakeMode;
            this.intFakeMode$set = true;
            return this;
        }

        public FakeConfigBuilder bigintFakeMode(FakeOption.FakeMode bigintFakeMode) {
            this.bigintFakeMode$value = bigintFakeMode;
            this.bigintFakeMode$set = true;
            return this;
        }

        public FakeConfigBuilder floatFakeMode(FakeOption.FakeMode floatFakeMode) {
            this.floatFakeMode$value = floatFakeMode;
            this.floatFakeMode$set = true;
            return this;
        }

        public FakeConfigBuilder doubleFakeMode(FakeOption.FakeMode doubleFakeMode) {
            this.doubleFakeMode$value = doubleFakeMode;
            this.doubleFakeMode$set = true;
            return this;
        }

        public FakeConfigBuilder stringTemplate(List<String> stringTemplate) {
            this.stringTemplate = stringTemplate;
            return this;
        }

        public FakeConfigBuilder tinyintTemplate(List<Integer> tinyintTemplate) {
            this.tinyintTemplate = tinyintTemplate;
            return this;
        }

        public FakeConfigBuilder smallintTemplate(List<Integer> smallintTemplate) {
            this.smallintTemplate = smallintTemplate;
            return this;
        }

        public FakeConfigBuilder intTemplate(List<Integer> intTemplate) {
            this.intTemplate = intTemplate;
            return this;
        }

        public FakeConfigBuilder bigTemplate(List<Long> bigTemplate) {
            this.bigTemplate = bigTemplate;
            return this;
        }

        public FakeConfigBuilder floatTemplate(List<Double> floatTemplate) {
            this.floatTemplate = floatTemplate;
            return this;
        }

        public FakeConfigBuilder doubleTemplate(List<Double> doubleTemplate) {
            this.doubleTemplate = doubleTemplate;
            return this;
        }

        public FakeConfigBuilder dateYearTemplate(List<Integer> dateYearTemplate) {
            this.dateYearTemplate = dateYearTemplate;
            return this;
        }

        public FakeConfigBuilder dateMonthTemplate(List<Integer> dateMonthTemplate) {
            this.dateMonthTemplate = dateMonthTemplate;
            return this;
        }

        public FakeConfigBuilder dateDayTemplate(List<Integer> dateDayTemplate) {
            this.dateDayTemplate = dateDayTemplate;
            return this;
        }

        public FakeConfigBuilder timeHourTemplate(List<Integer> timeHourTemplate) {
            this.timeHourTemplate = timeHourTemplate;
            return this;
        }

        public FakeConfigBuilder timeMinuteTemplate(List<Integer> timeMinuteTemplate) {
            this.timeMinuteTemplate = timeMinuteTemplate;
            return this;
        }

        public FakeConfigBuilder timeSecondTemplate(List<Integer> timeSecondTemplate) {
            this.timeSecondTemplate = timeSecondTemplate;
            return this;
        }

        public FakeConfigBuilder fakeRows(List<RowData> fakeRows) {
            this.fakeRows = fakeRows;
            return this;
        }

        public FakeConfigBuilder catalogTable(CatalogTable catalogTable) {
            this.catalogTable = catalogTable;
            return this;
        }

        public FakeConfig build() {
            int rowNum$value = this.rowNum$value;
            if (!this.rowNum$set) {
                rowNum$value = FakeConfig.$default$rowNum();
            }
            int splitNum$value = this.splitNum$value;
            if (!this.splitNum$set) {
                splitNum$value = FakeConfig.$default$splitNum();
            }
            int splitReadInterval$value = this.splitReadInterval$value;
            if (!this.splitReadInterval$set) {
                splitReadInterval$value = FakeConfig.$default$splitReadInterval();
            }
            int mapSize$value = this.mapSize$value;
            if (!this.mapSize$set) {
                mapSize$value = FakeConfig.$default$mapSize();
            }
            int arraySize$value = this.arraySize$value;
            if (!this.arraySize$set) {
                arraySize$value = FakeConfig.$default$arraySize();
            }
            int bytesLength$value = this.bytesLength$value;
            if (!this.bytesLength$set) {
                bytesLength$value = FakeConfig.$default$bytesLength();
            }
            int stringLength$value = this.stringLength$value;
            if (!this.stringLength$set) {
                stringLength$value = FakeConfig.$default$stringLength();
            }
            int tinyintMin$value = this.tinyintMin$value;
            if (!this.tinyintMin$set) {
                tinyintMin$value = FakeConfig.$default$tinyintMin();
            }
            int tinyintMax$value = this.tinyintMax$value;
            if (!this.tinyintMax$set) {
                tinyintMax$value = FakeConfig.$default$tinyintMax();
            }
            int smallintMin$value = this.smallintMin$value;
            if (!this.smallintMin$set) {
                smallintMin$value = FakeConfig.$default$smallintMin();
            }
            int smallintMax$value = this.smallintMax$value;
            if (!this.smallintMax$set) {
                smallintMax$value = FakeConfig.$default$smallintMax();
            }
            int intMin$value = this.intMin$value;
            if (!this.intMin$set) {
                intMin$value = FakeConfig.$default$intMin();
            }
            int intMax$value = this.intMax$value;
            if (!this.intMax$set) {
                intMax$value = FakeConfig.$default$intMax();
            }
            long bigintMin$value = this.bigintMin$value;
            if (!this.bigintMin$set) {
                bigintMin$value = FakeConfig.$default$bigintMin();
            }
            long bigintMax$value = this.bigintMax$value;
            if (!this.bigintMax$set) {
                bigintMax$value = FakeConfig.$default$bigintMax();
            }
            double floatMin$value = this.floatMin$value;
            if (!this.floatMin$set) {
                floatMin$value = FakeConfig.$default$floatMin();
            }
            double floatMax$value = this.floatMax$value;
            if (!this.floatMax$set) {
                floatMax$value = FakeConfig.$default$floatMax();
            }
            double doubleMin$value = this.doubleMin$value;
            if (!this.doubleMin$set) {
                doubleMin$value = FakeConfig.$default$doubleMin();
            }
            double doubleMax$value = this.doubleMax$value;
            if (!this.doubleMax$set) {
                doubleMax$value = FakeConfig.$default$doubleMax();
            }
            float vectorFloatMin$value = this.vectorFloatMin$value;
            if (!this.vectorFloatMin$set) {
                vectorFloatMin$value = FakeConfig.$default$vectorFloatMin();
            }
            float vectorFloatMax$value = this.vectorFloatMax$value;
            if (!this.vectorFloatMax$set) {
                vectorFloatMax$value = FakeConfig.$default$vectorFloatMax();
            }
            int vectorDimension$value = this.vectorDimension$value;
            if (!this.vectorDimension$set) {
                vectorDimension$value = FakeConfig.$default$vectorDimension();
            }
            int binaryVectorDimension$value = this.binaryVectorDimension$value;
            if (!this.binaryVectorDimension$set) {
                binaryVectorDimension$value = FakeConfig.$default$binaryVectorDimension();
            }
            FakeOption.FakeMode stringFakeMode$value = this.stringFakeMode$value;
            if (!this.stringFakeMode$set) {
                stringFakeMode$value = FakeConfig.$default$stringFakeMode();
            }
            FakeOption.FakeMode tinyintFakeMode$value = this.tinyintFakeMode$value;
            if (!this.tinyintFakeMode$set) {
                tinyintFakeMode$value = FakeConfig.$default$tinyintFakeMode();
            }
            FakeOption.FakeMode smallintFakeMode$value = this.smallintFakeMode$value;
            if (!this.smallintFakeMode$set) {
                smallintFakeMode$value = FakeConfig.$default$smallintFakeMode();
            }
            FakeOption.FakeMode intFakeMode$value = this.intFakeMode$value;
            if (!this.intFakeMode$set) {
                intFakeMode$value = FakeConfig.$default$intFakeMode();
            }
            FakeOption.FakeMode bigintFakeMode$value = this.bigintFakeMode$value;
            if (!this.bigintFakeMode$set) {
                bigintFakeMode$value = FakeConfig.$default$bigintFakeMode();
            }
            FakeOption.FakeMode floatFakeMode$value = this.floatFakeMode$value;
            if (!this.floatFakeMode$set) {
                floatFakeMode$value = FakeConfig.$default$floatFakeMode();
            }
            FakeOption.FakeMode doubleFakeMode$value = this.doubleFakeMode$value;
            if (!this.doubleFakeMode$set) {
                doubleFakeMode$value = FakeConfig.$default$doubleFakeMode();
            }
            return new FakeConfig(rowNum$value, splitNum$value, splitReadInterval$value, mapSize$value, arraySize$value, bytesLength$value, stringLength$value, tinyintMin$value, tinyintMax$value, smallintMin$value, smallintMax$value, intMin$value, intMax$value, bigintMin$value, bigintMax$value, floatMin$value, floatMax$value, doubleMin$value, doubleMax$value, vectorFloatMin$value, vectorFloatMax$value, vectorDimension$value, binaryVectorDimension$value, stringFakeMode$value, tinyintFakeMode$value, smallintFakeMode$value, intFakeMode$value, bigintFakeMode$value, floatFakeMode$value, doubleFakeMode$value, this.stringTemplate, this.tinyintTemplate, this.smallintTemplate, this.intTemplate, this.bigTemplate, this.floatTemplate, this.doubleTemplate, this.dateYearTemplate, this.dateMonthTemplate, this.dateDayTemplate, this.timeHourTemplate, this.timeMinuteTemplate, this.timeSecondTemplate, this.fakeRows, this.catalogTable);
        }

        public String toString() {
            return "FakeConfig.FakeConfigBuilder(rowNum$value=" + this.rowNum$value + ", splitNum$value=" + this.splitNum$value + ", splitReadInterval$value=" + this.splitReadInterval$value + ", mapSize$value=" + this.mapSize$value + ", arraySize$value=" + this.arraySize$value + ", bytesLength$value=" + this.bytesLength$value + ", stringLength$value=" + this.stringLength$value + ", tinyintMin$value=" + this.tinyintMin$value + ", tinyintMax$value=" + this.tinyintMax$value + ", smallintMin$value=" + this.smallintMin$value + ", smallintMax$value=" + this.smallintMax$value + ", intMin$value=" + this.intMin$value + ", intMax$value=" + this.intMax$value + ", bigintMin$value=" + this.bigintMin$value + ", bigintMax$value=" + this.bigintMax$value + ", floatMin$value=" + this.floatMin$value + ", floatMax$value=" + this.floatMax$value + ", doubleMin$value=" + this.doubleMin$value + ", doubleMax$value=" + this.doubleMax$value + ", vectorFloatMin$value=" + this.vectorFloatMin$value + ", vectorFloatMax$value=" + this.vectorFloatMax$value + ", vectorDimension$value=" + this.vectorDimension$value + ", binaryVectorDimension$value=" + this.binaryVectorDimension$value + ", stringFakeMode$value=" + (Object)((Object)this.stringFakeMode$value) + ", tinyintFakeMode$value=" + (Object)((Object)this.tinyintFakeMode$value) + ", smallintFakeMode$value=" + (Object)((Object)this.smallintFakeMode$value) + ", intFakeMode$value=" + (Object)((Object)this.intFakeMode$value) + ", bigintFakeMode$value=" + (Object)((Object)this.bigintFakeMode$value) + ", floatFakeMode$value=" + (Object)((Object)this.floatFakeMode$value) + ", doubleFakeMode$value=" + (Object)((Object)this.doubleFakeMode$value) + ", stringTemplate=" + this.stringTemplate + ", tinyintTemplate=" + this.tinyintTemplate + ", smallintTemplate=" + this.smallintTemplate + ", intTemplate=" + this.intTemplate + ", bigTemplate=" + this.bigTemplate + ", floatTemplate=" + this.floatTemplate + ", doubleTemplate=" + this.doubleTemplate + ", dateYearTemplate=" + this.dateYearTemplate + ", dateMonthTemplate=" + this.dateMonthTemplate + ", dateDayTemplate=" + this.dateDayTemplate + ", timeHourTemplate=" + this.timeHourTemplate + ", timeMinuteTemplate=" + this.timeMinuteTemplate + ", timeSecondTemplate=" + this.timeSecondTemplate + ", fakeRows=" + this.fakeRows + ", catalogTable=" + this.catalogTable + ")";
        }
    }

    public static class RowData
    implements Serializable {
        static final String KEY_KIND = "kind";
        static final String KEY_FIELDS = "fields";
        private String kind;
        private String fieldsJson;

        public String getKind() {
            return this.kind;
        }

        public String getFieldsJson() {
            return this.fieldsJson;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public void setFieldsJson(String fieldsJson) {
            this.fieldsJson = fieldsJson;
        }

        public RowData(String kind, String fieldsJson) {
            this.kind = kind;
            this.fieldsJson = fieldsJson;
        }
    }
}

