/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.ResultIterator;
import java.util.UUID;

public class QueryClientState {
    private final UUID clientId;
    private final QueryId queryId;
    private final AbstractSqlResult sqlResult;
    private final boolean closed;
    private final long createdAt;
    private ResultIterator<SqlRow> iterator;

    public QueryClientState(UUID clientId, QueryId queryId, AbstractSqlResult sqlResult, boolean closed) {
        this.clientId = clientId;
        this.queryId = queryId;
        this.sqlResult = sqlResult;
        this.closed = closed;
        this.createdAt = System.nanoTime();
    }

    public UUID getClientId() {
        return this.clientId;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public AbstractSqlResult getSqlResult() {
        return this.sqlResult;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public long getCreatedAtNano() {
        return this.createdAt;
    }

    public ResultIterator<SqlRow> getIterator() {
        assert (this.sqlResult != null);
        if (this.iterator == null) {
            this.iterator = this.sqlResult.iterator();
        }
        return this.iterator;
    }
}

