/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.metrics;

import java.util.Map;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;

public class MessageMetrics
extends RatisMetrics {
    public static final String GRPC_MESSAGE_METRICS = "%s_message_metrics";
    public static final String GRPC_MESSAGE_METRICS_DESC = "Outbound/Inbound message counters";
    private final Map<Type, Map<String, LongCounter>> types = MessageMetrics.newCounterMaps(Type.class);

    public MessageMetrics(String endpointId, String endpointType) {
        super(MessageMetrics.createRegistry(endpointId, endpointType));
    }

    private static RatisMetricRegistry createRegistry(String endpointId, String endpointType) {
        String name = String.format(GRPC_MESSAGE_METRICS, endpointType);
        return MessageMetrics.create(new MetricRegistryInfo(endpointId, "ratis", name, GRPC_MESSAGE_METRICS_DESC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inc(String metricNamePrefix, Type t2) {
        this.types.get((Object)t2).computeIfAbsent(metricNamePrefix, prefix -> this.getRegistry().counter(prefix + t2.getSuffix())).inc();
        Map<String, LongCounter> counters = this.types.get((Object)t2);
        LongCounter c = counters.get(metricNamePrefix);
        if (c == null) {
            Map<String, LongCounter> map = counters;
            synchronized (map) {
                c = counters.computeIfAbsent(metricNamePrefix, prefix -> this.getRegistry().counter(prefix + t2.getSuffix()));
            }
        }
        c.inc();
    }

    public void rpcStarted(String metricNamePrefix) {
        this.inc(metricNamePrefix, Type.STARTED);
    }

    public void rpcCompleted(String metricNamePrefix) {
        this.inc(metricNamePrefix, Type.COMPLETED);
    }

    public void rpcReceived(String metricNamePrefix) {
        this.inc(metricNamePrefix, Type.RECEIVED);
    }

    private static enum Type {
        STARTED("_started_total"),
        COMPLETED("_completed_total"),
        RECEIVED("_received_executed");

        private final String suffix;

        private Type(String suffix) {
            this.suffix = suffix;
        }

        String getSuffix() {
            return this.suffix;
        }
    }
}

