/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.ha;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.ranger.RangerHAInitializer;
import org.apache.ranger.ha.ActiveInstanceElectorService;
import org.apache.ranger.ha.ActiveStateChangeHandler;
import org.apache.ranger.ha.ServiceState;
import org.apache.ranger.ha.service.HARangerService;
import org.apache.ranger.ha.service.ServiceManager;

public class TagSyncHAInitializerImpl
extends RangerHAInitializer {
    private static final Logger LOG = Logger.getLogger(TagSyncHAInitializerImpl.class);
    ActiveInstanceElectorService activeInstanceElectorService = null;
    ActiveStateChangeHandler activeStateChangeHandler = null;
    List<HARangerService> haRangerService = null;
    ServiceManager serviceManager = null;
    private static TagSyncHAInitializerImpl theInstance = null;

    private TagSyncHAInitializerImpl(Configuration configuration) {
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)"==> TagSyncHAInitializerImpl.TagSyncHAInitializerImpl()");
        }
        try {
            LOG.info((Object)("Ranger TagSync server is HA enabled : " + configuration.getBoolean("ranger-tagsync.server.ha.enabled", false)));
            this.init(configuration);
        }
        catch (Exception e) {
            LOG.error((Object)"TagSyncHAInitializerImpl initialization failed", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)"<== TagSyncHAInitializerImpl.TagSyncHAInitializerImpl()");
        }
    }

    public void init(Configuration configuration) throws Exception {
        super.init(configuration);
        LOG.info((Object)"==> TagSyncHAInitializerImpl.init() initialization started");
        HashSet activeStateChangeHandlerProviders = new HashSet();
        this.activeInstanceElectorService = new ActiveInstanceElectorService(activeStateChangeHandlerProviders, this.curatorFactory, this.activeInstanceState, this.serviceState, configuration);
        this.haRangerService = new ArrayList<HARangerService>();
        this.haRangerService.add((HARangerService)this.activeInstanceElectorService);
        this.serviceManager = new ServiceManager(this.haRangerService);
        LOG.info((Object)"<== TagSyncHAInitializerImpl.init() initialization completed");
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagSyncHAInitializerImpl.stop() ");
        }
        if (this.serviceManager != null) {
            this.serviceManager.stop();
        }
        if (this.curatorFactory != null) {
            this.curatorFactory.close();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== TagSyncHAInitializerImpl.stop() ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TagSyncHAInitializerImpl getInstance(Configuration configuration) {
        if (theInstance != null) return theInstance;
        Class<TagSyncHAInitializerImpl> clazz = TagSyncHAInitializerImpl.class;
        synchronized (TagSyncHAInitializerImpl.class) {
            if (theInstance != null) return theInstance;
            theInstance = new TagSyncHAInitializerImpl(configuration);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return theInstance;
        }
    }

    public boolean isActive() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serviceState.getState().equals((Object)ServiceState.ServiceStateValue.ACTIVE);
    }
}

