/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sun.jersey.api.client.ClientResponse;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerPluginCapability;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.plugin.util.URLEncoderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAdminRESTClient
extends AbstractRangerAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAdminRESTClient.class);
    private static final TypeReference<List<String>> TYPE_LIST_STRING = new TypeReference<List<String>>(){};
    private String serviceName;
    private String serviceNameUrlParam;
    private String pluginId;
    private String clusterName;
    private RangerRESTClient restClient;
    private RangerRESTUtils restUtils = new RangerRESTUtils();
    private boolean supportsPolicyDeltas;
    private boolean supportsTagDeltas;
    private boolean isRangerCookieEnabled;
    private String rangerAdminCookieName;
    private Cookie sessionId = null;
    private final String pluginCapabilities = Long.toHexString(new RangerPluginCapability().getPluginCapabilities());

    @Override
    public void init(String serviceName, String appId, String propertyPrefix, Configuration config) {
        super.init(serviceName, appId, propertyPrefix, config);
        this.serviceName = serviceName;
        this.pluginId = this.restUtils.getPluginId(serviceName, appId);
        String url = "";
        String tmpUrl = config.get(propertyPrefix + ".policy.rest.url");
        String sslConfigFileName = config.get(propertyPrefix + ".policy.rest.ssl.config.file");
        this.clusterName = config.get(propertyPrefix + ".access.cluster.name", "");
        if (StringUtil.isEmpty(this.clusterName)) {
            this.clusterName = config.get(propertyPrefix + ".ambari.cluster.name", "");
            if (StringUtil.isEmpty(this.clusterName) && config instanceof RangerPluginConfig) {
                this.clusterName = ((RangerPluginConfig)config).getClusterName();
            }
        }
        int restClientConnTimeOutMs = config.getInt(propertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        int restClientReadTimeOutMs = config.getInt(propertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        int restClientMaxRetryAttempts = config.getInt(propertyPrefix + ".policy.rest.client.max.retry.attempts", 3);
        int restClientRetryIntervalMs = config.getInt(propertyPrefix + ".policy.rest.client.retry.interval.ms", 1000);
        this.supportsPolicyDeltas = config.getBoolean(propertyPrefix + ".supports.policy.deltas", false);
        this.supportsTagDeltas = config.getBoolean(propertyPrefix + ".supports.tag.deltas", false);
        this.isRangerCookieEnabled = config.getBoolean(propertyPrefix + ".policy.rest.client.cookie.enabled", true);
        this.rangerAdminCookieName = config.get(propertyPrefix + ".policy.rest.client.session.cookie.name", "RANGERADMINSESSIONID");
        if (!StringUtil.isEmpty(tmpUrl)) {
            url = tmpUrl.trim();
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.init(url, sslConfigFileName, restClientConnTimeOutMs, restClientReadTimeOutMs, restClientMaxRetryAttempts, restClientRetryIntervalMs, config);
        try {
            this.serviceNameUrlParam = URLEncoderUtil.encodeURIParam(serviceName);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Unsupported encoding, serviceName=" + serviceName);
            this.serviceNameUrlParam = serviceName;
        }
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        RESTResponse resp;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("supportsPolicyDeltas", Boolean.toString(this.supportsPolicyDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated as user : " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    String relativeURL = "/service/plugins/secure/policies/download/" + this.serviceNameUrlParam;
                    return this.restClient.get(relativeURL, queryParams, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated with old api call");
            }
            String relativeURL = "/service/plugins/policies/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response == null || response.getStatus() == 304 || response.getStatus() == 204) {
            if (response == null) {
                LOG.error("Error getting policies; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = JsonUtilsV2.readResponse(response, ServicePolicies.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting policies; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    @Override
    public RangerRoles getRolesIfUpdated(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        RangerRoles ret;
        RESTResponse resp;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getRolesIfUpdated(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownRoleVersion", Long.toString(lastKnownRoleVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Roles updated as user : " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    String relativeURL = "/service/roles/secure/download/" + this.serviceNameUrlParam;
                    return this.restClient.get(relativeURL, queryParams, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Roles updated as user : " + user);
            }
            String relativeURL = "/service/roles/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response == null || response.getStatus() == 304 || response.getStatus() == 204) {
            if (response == null) {
                LOG.error("Error getting Roles; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in Roles. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownRoleVersion=" + lastKnownRoleVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = JsonUtilsV2.readResponse(response, RangerRoles.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting Roles; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownRoleVersion=" + lastKnownRoleVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting Roles. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getRolesIfUpdated(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        return ret;
    }

    @Override
    public RangerRole createRole(RangerRole request) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.createRole(" + request + ")");
        }
        RangerRole ret = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        String relativeURL = "/service/public/v2/api/roles/";
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("create role as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    return this.restClient.post(relativeURL, queryParams, request, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            response = this.restClient.post(relativeURL, queryParams, request, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("createRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during createRole. roleName=" + request.getName());
        }
        ret = JsonUtilsV2.readResponse(response, RangerRole.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.createRole(" + request + ")");
        }
        return ret;
    }

    @Override
    public void dropRole(String execUser, String roleName) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.dropRole(" + roleName + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        String relativeURL = "/service/public/v2/api/roles/name/" + roleName;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("drop role as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    return this.restClient.delete(relativeURL, queryParams, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            response = this.restClient.delete(relativeURL, queryParams, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response == null) {
            throw new Exception("unknown error during deleteRole. roleName=" + roleName);
        }
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("createRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.deleteRole(" + roleName + ")");
        }
    }

    @Override
    public List<String> getUserRoles(String execUser) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getUserRoles(" + execUser + ")");
        }
        List<String> ret = null;
        String emptyString = "";
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        String relativeURL = "/service/public/v2/api/roles/user/" + execUser;
        Cookie sessionId = this.sessionId;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("get roles as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    return this.restClient.get(relativeURL, null, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            response = this.restClient.get(relativeURL, null, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error("getUserRoles() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getUserRoles. execUser=" + execUser);
        }
        ret = JsonUtilsV2.readResponse(response, TYPE_LIST_STRING);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getUserRoles(" + execUser + ")");
        }
        return ret;
    }

    @Override
    public List<String> getAllRoles(String execUser) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getAllRoles()");
        }
        List<String> ret = null;
        String emptyString = "";
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        String relativeURL = "/service/public/v2/api/roles/names/";
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("get roles as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    return this.restClient.get(relativeURL, queryParams, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            response = this.restClient.get(relativeURL, queryParams, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error("getAllRoles() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getAllRoles.");
        }
        ret = JsonUtilsV2.readResponse(response, TYPE_LIST_STRING);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getAllRoles()");
        }
        return ret;
    }

    @Override
    public RangerRole getRole(String execUser, String roleName) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getPrincipalsForRole(" + roleName + ")");
        }
        RangerRole ret = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        String relativeURL = "/service/public/v2/api/roles/name/" + roleName;
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("get role info as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    return this.restClient.get(relativeURL, queryParams, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            response = this.restClient.get(relativeURL, queryParams, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error("getPrincipalsForRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getPrincipalsForRole. roleName=" + roleName);
        }
        ret = JsonUtilsV2.readResponse(response, RangerRole.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getPrincipalsForRole(" + roleName + ")");
        }
        return ret;
    }

    @Override
    public void grantRole(GrantRevokeRoleRequest request) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.grantRole(" + request + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        String relativeURL = "/service/public/v2/api/roles/grant/" + this.serviceNameUrlParam;
        Cookie sessionId = this.sessionId;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("grant role as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    return this.restClient.put(relativeURL, request, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            response = this.restClient.put(relativeURL, request, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("grantRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantRole. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.grantRole(" + request + ")");
        }
    }

    @Override
    public void revokeRole(GrantRevokeRoleRequest request) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.revokeRole(" + request + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        String relativeURL = "/service/public/v2/api/roles/revoke/" + this.serviceNameUrlParam;
        Cookie sessionId = this.sessionId;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("revoke role as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    return this.restClient.put(relativeURL, request, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            response = this.restClient.put(relativeURL, request, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("revokeRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during revokeRole. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.revokeRole(" + request + ")");
        }
    }

    @Override
    public void grantAccess(GrantRevokeRequest request) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.grantAccess(" + request + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this.pluginId);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("grantAccess as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    String relativeURL = "/service/plugins/secure/services/grant/" + this.serviceNameUrlParam;
                    return this.restClient.post(relativeURL, queryParams, request, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            String relativeURL = "/service/plugins/services/grant/" + this.serviceNameUrlParam;
            response = this.restClient.post(relativeURL, queryParams, request, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("grantAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantAccess. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.grantAccess(" + request + ")");
        }
    }

    @Override
    public void revokeAccess(GrantRevokeRequest request) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.revokeAccess(" + request + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this.pluginId);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("revokeAccess as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    String relativeURL = "/service/plugins/secure/services/revoke/" + this.serviceNameUrlParam;
                    return this.restClient.post(relativeURL, queryParams, request, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            String relativeURL = "/service/plugins/services/revoke/" + this.serviceNameUrlParam;
            response = this.restClient.post(relativeURL, queryParams, request, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("revokeAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error. revokeAccess(). serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.revokeAccess(" + request + ")");
        }
    }

    private void init(String url, String sslConfigFileName, int restClientConnTimeOutMs, int restClientReadTimeOutMs, int restClientMaxRetryAttempts, int restClientRetryIntervalMs, Configuration config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")");
        }
        this.restClient = new RangerRESTClient(url, sslConfigFileName, config);
        this.restClient.setRestClientConnTimeOutMs(restClientConnTimeOutMs);
        this.restClient.setRestClientReadTimeOutMs(restClientReadTimeOutMs);
        this.restClient.setMaxRetryAttempts(restClientMaxRetryAttempts);
        this.restClient.setRetryIntervalMs(restClientRetryIntervalMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")");
        }
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags ret;
        RESTResponse resp;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("supportsTagDeltas", Boolean.toString(this.supportsTagDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getServiceTagsIfUpdated as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    String relativeURL = "/service/tags/secure/download/" + this.serviceNameUrlParam;
                    return this.restClient.get(relativeURL, queryParams, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            String relativeURL = "/service/tags/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting tags; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = JsonUtilsV2.readResponse(response, ServiceTags.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting tags; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        return ret;
    }

    @Override
    public List<String> getTagTypes(String pattern) throws Exception {
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getTagTypes(" + pattern + "): ");
        }
        List<String> ret = null;
        String emptyString = "";
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("pattern", pattern);
        String relativeURL = "/service/tags/lookup";
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTagTypes as user " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    return this.restClient.get(relativeURL, queryParams, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            response = this.restClient.get(relativeURL, queryParams, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("Error getting tags. response=" + resp + ", serviceName=" + this.serviceName + ", pattern=" + pattern);
            throw new Exception(resp.getMessage());
        }
        ret = JsonUtilsV2.readResponse(response, TYPE_LIST_STRING);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getTagTypes(" + pattern + "): " + ret);
        }
        return ret;
    }

    @Override
    public RangerUserStore getUserStoreIfUpdated(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore ret;
        RESTResponse resp;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getUserStoreIfUpdated(" + lastKnownUserStoreVersion + ", " + lastActivationTimeInMillis + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        Cookie sessionId = this.sessionId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownUserStoreVersion", Long.toString(lastKnownUserStoreVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking UserStore updated as user : " + user);
            }
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    String relativeURL = "/service/xusers/secure/download/" + this.serviceNameUrlParam;
                    return this.restClient.get(relativeURL, queryParams, sessionId);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : " + e.getMessage());
                    return null;
                }
            });
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking UserStore updated as user : " + user);
            }
            String relativeURL = "/service/xusers/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams, sessionId);
        }
        this.checkAndResetSessionCookie(response);
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting UserStore; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in UserStore. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownUserStoreVersion=" + lastKnownUserStoreVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = JsonUtilsV2.readResponse(response, RangerUserStore.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting UserStore; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownUserStoreVersion=" + lastKnownUserStoreVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting UserStore. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getUserStoreIfUpdated(" + lastKnownUserStoreVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        return ret;
    }

    private void checkAndResetSessionCookie(ClientResponse response) {
        if (this.isRangerCookieEnabled) {
            if (response == null) {
                LOG.debug("checkAndResetSessionCookie(): RESETTING sessionId - response is null");
                this.sessionId = null;
            } else {
                int status = response.getStatus();
                if (status == 200 || status == 204 || status == 304) {
                    NewCookie newCookie = null;
                    for (NewCookie cookie : response.getCookies()) {
                        if (!cookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                        newCookie = cookie;
                        break;
                    }
                    if (this.sessionId == null || newCookie != null) {
                        LOG.debug("checkAndResetSessionCookie(): status={}, sessionIdCookie={}, newCookie={}", new Object[]{status, this.sessionId, newCookie});
                        this.sessionId = newCookie;
                    }
                } else {
                    LOG.debug("checkAndResetSessionCookie(): RESETTING sessionId - status={}", (Object)status);
                    this.sessionId = null;
                }
            }
        }
    }
}

