/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.stats.outlierdetection;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.client.ml.dataframe.stats.outlierdetection.Parameters;
import org.elasticsearch.client.ml.dataframe.stats.outlierdetection.TimingStats;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class OutlierDetectionStats
implements AnalysisStats {
    public static final ParseField NAME = new ParseField("outlier_detection_stats", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField PARAMETERS = new ParseField("parameters", new String[0]);
    public static final ParseField TIMING_STATS = new ParseField("timing_stats", new String[0]);
    public static final ConstructingObjectParser<OutlierDetectionStats, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new OutlierDetectionStats((Instant)a[0], (Parameters)a[1], (TimingStats)a[2]));
    private final Instant timestamp;
    private final Parameters parameters;
    private final TimingStats timingStats;

    public OutlierDetectionStats(Instant timestamp, Parameters parameters, TimingStats timingStats) {
        this.timestamp = Instant.ofEpochMilli(Objects.requireNonNull(timestamp).toEpochMilli());
        this.parameters = Objects.requireNonNull(parameters);
        this.timingStats = Objects.requireNonNull(timingStats);
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public TimingStats getTimingStats() {
        return this.timingStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        builder.field(PARAMETERS.getPreferredName(), (ToXContent)this.parameters);
        builder.field(TIMING_STATS.getPreferredName(), (ToXContent)this.timingStats);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlierDetectionStats that = (OutlierDetectionStats)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.timingStats, that.timingStats);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.parameters, this.timingStats);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), Parameters.PARSER, PARAMETERS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TimingStats.PARSER, TIMING_STATS);
    }
}

