/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;

public final class GroupedActionListener<T>
implements ActionListener<T> {
    private final CountDown countDown;
    private final AtomicInteger pos = new AtomicInteger();
    private final AtomicArray<T> results;
    private final ActionListener<Collection<T>> delegate;
    private final AtomicReference<Exception> failure = new AtomicReference();

    public GroupedActionListener(ActionListener<Collection<T>> delegate, int groupSize) {
        if (groupSize <= 0) {
            throw new IllegalArgumentException("groupSize must be greater than 0 but was " + groupSize);
        }
        this.results = new AtomicArray(groupSize);
        this.countDown = new CountDown(groupSize);
        this.delegate = delegate;
    }

    @Override
    public void onResponse(T element) {
        this.results.setOnce(this.pos.incrementAndGet() - 1, element);
        if (this.countDown.countDown()) {
            if (this.failure.get() != null) {
                this.delegate.onFailure(this.failure.get());
            } else {
                List<T> collect = this.results.asList();
                this.delegate.onResponse(Collections.unmodifiableList(collect));
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        if (!this.failure.compareAndSet(null, e)) {
            this.failure.accumulateAndGet(e, (current, update) -> {
                if (update != current) {
                    current.addSuppressed((Throwable)update);
                }
                return current;
            });
        }
        if (this.countDown.countDown()) {
            this.delegate.onFailure(this.failure.get());
        }
    }
}

