/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.bridges.script;

import java.io.IOException;
import java.io.InputStream;

/**
 * ScriptSource
 * <P>
 * Representing a script source. 
 * </P>
 * 
 * @author <a href="mailto:woonsan@apache.org">Woonsan Ko</a>
 * @version $Id: ScriptSource.java 937248 2010-04-23 11:06:13Z woonsan $
 */
public interface ScriptSource
{
    /**
     * Returns the name part of the script.
     * @return
     */
    public String getName();
    
    /**
     * Returns the extension of the script without leading dot.
     * @return
     */
    public String getExtension();
    
    /**
     * Returns the character encoding of the script content.
     * If the character encoding of the script content is unknown, returns null. 
     * @return
     */
    public String getCharacterEncoding();
    
    /**
     * Sets the mime type of this script.
     * @param mimeType
     */
    public void setMimeType(String mimeType);
    
    /**
     * Returns the mime type of this script.
     * If the mime type of the script is not set or unknown, returns null.
     * @return
     */
    public String getMimeType();
    
    /**
     * Returns the time that the script file was last modified if accessible.
     * If the script file is not accessible, returns 0L.
     * @return
     */
    public long lastModified();
    
    /**
     * Returns an input stream to read this script.
     * @return
     * @throws IOException
     */
    public InputStream getInputStream() throws IOException;
    
}
