/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.bridges.script;

import java.io.IOException;

/**
 * ScriptSourceFactory
 * <P>
 * Representing a script source factory
 * </P>
 * 
 * @author <a href="mailto:woonsan@apache.org">Woonsan Ko</a>
 * @version $Id: ScriptSourceFactory.java 937248 2010-04-23 11:06:13Z woonsan $
 */
public interface ScriptSourceFactory
{
    /**
     * Creates a script source based on uri
     * @param uri
     * @return
     * @throws IOException
     */
    public ScriptSource createScriptSource(final String uri) throws IOException;
    
    /**
     * Creates a script source based on uri and uriEncoding.
     * @param uri
     * @param uriEncoding
     * @return
     * @throws IOException
     */
    public ScriptSource createScriptSource(final String uri, final String uriEncoding) throws IOException;
    
    /**
     * Creates a script source based on uri, uriEncoding and characterEncoding.
     * @param uri
     * @param uriEncoding
     * @param characterEncoding
     * @return
     * @throws IOException
     */
    public ScriptSource createScriptSource(final String uri, final String uriEncoding, final String characterEncoding) throws IOException;
}
