/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.bridges.script;

import java.io.IOException;
import java.io.InputStream;

/**
 * DelegatingScriptSourceAdaptor
 * <P>
 * Simple adaptor class implementing ScriptSource by delegating all to the delegatee
 * </P>
 * 
 * @author <a href="mailto:woonsan@apache.org">Woonsan Ko</a>
 * @version $Id: DelegatingScriptSourceAdaptor.java 937248 2010-04-23 11:06:13Z woonsan $
 */
public class DelegatingScriptSourceAdaptor implements ScriptSource
{
    private ScriptSource delegatee;
    
    public DelegatingScriptSourceAdaptor(final ScriptSource delegatee)
    {
        if (delegatee == null)
        {
            throw new IllegalArgumentException("Delegatee cannot be null!");
        }
        
        this.delegatee = delegatee;
    }
    
    public String getName()
    {
        return delegatee.getName();
    }
    
    public String getExtension()
    {
        return delegatee.getExtension();
    }
    
    public String getCharacterEncoding()
    {
        return delegatee.getCharacterEncoding();
    }
    
    public void setMimeType(String mimeType)
    {
        delegatee.setMimeType(mimeType);
    }
    
    public String getMimeType()
    {
        return delegatee.getMimeType();
    }
    
    public long lastModified()
    {
        return delegatee.lastModified();
    }
    
    public InputStream getInputStream() throws IOException
    {
        return delegatee.getInputStream();
    }
}
