/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.rewriter;

import java.util.Map;

/**
 * Content Rewriting Context which can be used to share context variables
 * during the content rewriting process.
 */
public interface ContentRewritingContext
{

    /**
     * Returns true if the named attribute exists. Otherwise returns false.
     * @param name
     * @return
     */
    public boolean hasAttribute(String name);

    /**
     * Returns the value of the named attribute as an <code>Object</code>,
     * or <code>null</code> if no attribute of the given name exists. 
     * @param name
     * @return
     */
    public Object getAttribute(String name);

    /**
     * Returns a <code>Map</code> containing the attributes available. 
     * This method returns an empty <code>Map</code>
     * if there's no attributes available to it.
     * @return
     */
    public Map<String, Object> getAttributesMap();

    /**
     * Stores an attribute in this context.
     * @param name
     * @param value
     */
    public void setAttribute(String name, Object value);

    /**
     * Removes an attribute from this context.
     * @param name
     */
    public void removeAttribute(String name);

}
